/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.frostwire.bittorrent.BTDownload;
import com.frostwire.bittorrent.BTEngine;
import com.frostwire.bittorrent.BTEngineAdapter;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.settings.UpdateSettings;
import java.io.File;

public final class DownloadManagerImpl
implements DownloadManager {
    private static final Logger LOG = Logger.getLogger(DownloadManagerImpl.class);
    private final ActivityCallback activityCallback;

    public DownloadManagerImpl(ActivityCallback downloadCallback) {
        this.activityCallback = downloadCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDownload(BTDownload dl) {
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            this.activityCallback.addDownload(dl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDownload(BTDownload dl) {
        DownloadManagerImpl downloadManagerImpl = this;
        synchronized (downloadManagerImpl) {
            this.activityCallback.updateDownload(dl);
        }
    }

    @Override
    public void loadSavedDownloadsAndScheduleWriting() {
        try {
            BTEngine engine = BTEngine.getInstance();
            engine.setListener(new BTEngineAdapter(){

                @Override
                public void downloadAdded(BTEngine engine, BTDownload dl) {
                    if (engine == null || dl == null) {
                        return;
                    }
                    String name = dl.getName();
                    if (name == null || name.contains("fetch_magnet:")) {
                        return;
                    }
                    File savePath = dl.getSavePath();
                    if (savePath != null && savePath.toString().contains("fetch_magnet")) {
                        return;
                    }
                    if (savePath != null) {
                        File parentFile = savePath.getParentFile();
                        if (parentFile != null) {
                            if (parentFile.getAbsolutePath().equals(UpdateSettings.UPDATES_DIR.getAbsolutePath())) {
                                LOG.info("Update download, not adding to transfer manager: " + String.valueOf(savePath));
                                return;
                            }
                        } else if (savePath.getAbsolutePath().equals(UpdateSettings.UPDATES_DIR.getAbsolutePath())) {
                            LOG.info("Update download, not adding to transfer manager: " + String.valueOf(savePath));
                            return;
                        }
                    }
                    DownloadManagerImpl.this.addDownload(dl);
                }

                @Override
                public void downloadUpdate(BTEngine engine, BTDownload dl) {
                    DownloadManagerImpl.this.updateDownload(dl);
                }
            });
            engine.restoreDownloads();
        }
        catch (Throwable e) {
            LOG.error("General error loading saved downloads", e);
        }
    }
}

