/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util.http;

import com.frostwire.util.Logger;
import com.frostwire.util.Ssl;
import com.frostwire.util.StringUtils;
import com.frostwire.util.ThreadPool;
import com.frostwire.util.http.AbstractHttpClient;
import com.frostwire.util.http.HttpClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;

public class OkHttpClientWrapper
extends AbstractHttpClient {
    public static final ConnectionPool CONNECTION_POOL = new ConnectionPool(8, 30L, TimeUnit.SECONDS);
    private static final Logger LOG = Logger.getLogger(OkHttpClientWrapper.class);
    private final ThreadPool pool;

    public OkHttpClientWrapper(ThreadPool pool) {
        this.pool = pool;
    }

    public static void cancelAllRequests() {
        try {
            new Thread("OkHttpClientWrapper::cancelAllRequests"){

                @Override
                public void run() {
                    try {
                        CONNECTION_POOL.evictAll();
                    }
                    catch (Throwable t) {
                        LOG.error(t.getMessage(), t);
                    }
                }
            }.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static OkHttpClient.Builder newOkHttpClient(ThreadPool pool) {
        OkHttpClient.Builder searchClient = new OkHttpClient.Builder();
        searchClient.dispatcher(new Dispatcher(pool));
        searchClient.connectionPool(CONNECTION_POOL);
        searchClient.followRedirects(true);
        searchClient.connectTimeout(10000L, TimeUnit.MILLISECONDS);
        searchClient = OkHttpClientWrapper.configNullSsl(searchClient);
        return searchClient;
    }

    public static OkHttpClient.Builder configNullSsl(OkHttpClient.Builder b) {
        b.followSslRedirects(true);
        b.hostnameVerifier(Ssl.fwHostnameVerifier());
        b.sslSocketFactory(Ssl.nullSocketFactory(), Ssl.nullTrustManager());
        ConnectionSpec spec0 = OkHttpClientWrapper.cipherSpec(ConnectionSpec.CLEARTEXT);
        ConnectionSpec spec1 = OkHttpClientWrapper.cipherSpec(ConnectionSpec.COMPATIBLE_TLS);
        ConnectionSpec spec2 = OkHttpClientWrapper.cipherSpec(ConnectionSpec.MODERN_TLS);
        ConnectionSpec spec3 = OkHttpClientWrapper.cipherSpec(ConnectionSpec.RESTRICTED_TLS);
        b.connectionSpecs(Arrays.asList(spec0, spec1, spec2, spec3));
        return b;
    }

    private static ConnectionSpec cipherSpec(ConnectionSpec spec) {
        ConnectionSpec.Builder b = new ConnectionSpec.Builder(spec);
        if (spec.isTls()) {
            b = b.allEnabledCipherSuites();
            b = b.allEnabledTlsVersions();
        }
        return b.build();
    }

    @Override
    public int head(String url, int connectTimeoutInMillis, Map<String, List<String>> outputHeaders) throws IOException {
        OkHttpClient.Builder okHttpClient = this.newOkHttpClient();
        okHttpClient.connectTimeout(connectTimeoutInMillis, TimeUnit.MILLISECONDS);
        okHttpClient.followRedirects(false);
        Request req = new Request.Builder().url(url).header("User-Agent", DEFAULT_USER_AGENT).head().build();
        Response resp = okHttpClient.build().newCall(req).execute();
        OkHttpClientWrapper.closeQuietly(resp.body());
        OkHttpClientWrapper.copyMultiMap(resp.headers().toMultimap(), outputHeaders);
        return resp.code();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(String url, int timeout2, String userAgent, String referrer, String cookies) {
        byte[] result = null;
        OkHttpClient.Builder okHttpClient = this.newOkHttpClient();
        Request.Builder builder = this.prepareRequestBuilder(okHttpClient, url, timeout2, userAgent, referrer, cookies);
        ResponseBody responseBody = null;
        try {
            responseBody = this.getSyncResponse(okHttpClient, builder).body();
            if (responseBody != null) {
                result = responseBody.bytes();
            }
        }
        catch (Throwable e) {
            LOG.error("Error getting bytes from http body response: " + e.getMessage());
        }
        finally {
            if (responseBody != null) {
                OkHttpClientWrapper.closeQuietly(responseBody);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String url, int timeoutMillis, String userAgent, String referrer, String cookie, Map<String, String> customHeaders) throws IOException {
        String result = null;
        OkHttpClient.Builder okHttpClient = this.newOkHttpClient();
        Request.Builder builder = this.prepareRequestBuilder(okHttpClient, url, timeoutMillis, userAgent, referrer, cookie);
        this.addCustomHeaders(customHeaders, builder);
        ResponseBody responseBody = null;
        try {
            responseBody = this.getSyncResponse(okHttpClient, builder).body();
            if (responseBody != null) {
                result = responseBody.string();
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
        }
        finally {
            if (responseBody != null) {
                OkHttpClientWrapper.closeQuietly(responseBody);
            }
        }
        return result;
    }

    @Override
    public void save(String url, File file, boolean resume, int timeout2, String userAgent, String referrer) throws IOException {
        int n;
        long rangeStart;
        FileOutputStream fos;
        this.canceled = false;
        if (resume && file.exists()) {
            fos = new FileOutputStream(file, true);
            rangeStart = file.length();
        } else {
            fos = new FileOutputStream(file, false);
            rangeStart = -1L;
        }
        OkHttpClient.Builder okHttpClient = this.newOkHttpClient();
        Request.Builder builder = this.prepareRequestBuilder(okHttpClient, url, timeout2, userAgent, referrer, null);
        this.addRangeHeader(rangeStart, -1L, builder);
        Response response = this.getSyncResponse(okHttpClient, builder);
        Headers headers = response.headers();
        this.onHeaders(headers);
        InputStream in = response.body().byteStream();
        byte[] b = new byte[4096];
        while (!this.canceled && (n = in.read(b, 0, b.length)) != -1) {
            if (this.canceled) continue;
            fos.write(b, 0, n);
            this.onData(b, 0, n);
        }
        OkHttpClientWrapper.closeQuietly(fos);
        OkHttpClientWrapper.closeQuietly(response.body());
        if (this.canceled) {
            this.onCancel();
        } else {
            this.onComplete();
        }
    }

    private void onHeaders(Headers headers) {
        if (this.getListener() != null) {
            try {
                this.getListener().onHeaders(this, headers.toMultimap());
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    @Override
    public String post(String url, int timeout2, String userAgent, Map<String, String> formData) throws IOException {
        return this.post(url, timeout2, userAgent, "application/x-www-form-urlencoded; charset=utf-8", this.getFormDataBytes(formData), false);
    }

    @Override
    public String post(String url, int timeout2, String userAgent, String content, String postContentType, boolean gzip) throws IOException {
        return this.post(url, timeout2, userAgent, postContentType, content.getBytes(StandardCharsets.UTF_8), gzip);
    }

    private String post(String url, int timeout2, String userAgent, String postContentType, byte[] postData, boolean gzip) throws IOException {
        this.canceled = false;
        OkHttpClient.Builder okHttpClient = this.newOkHttpClient();
        Request.Builder builder = this.prepareRequestBuilder(okHttpClient, url, timeout2, userAgent, null, null);
        RequestBody requestBody = RequestBody.create(postData, MediaType.parse(postContentType));
        this.prepareOkHttpClientForPost(okHttpClient, gzip);
        builder.post(requestBody);
        return this.getPostSyncResponse(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPostSyncResponse(Request.Builder builder) throws IOException {
        String result = null;
        OkHttpClient.Builder okHttpClient = this.newOkHttpClient();
        Response response = this.getSyncResponse(okHttpClient, builder);
        try {
            int httpResponseCode = response.code();
            if (httpResponseCode != 200 && httpResponseCode != 206) {
                throw new HttpClient.ResponseCodeNotSupportedException(httpResponseCode);
            }
            if (this.canceled) {
                this.onCancel();
            } else {
                result = response.body().string();
                this.onComplete();
            }
        }
        finally {
            OkHttpClientWrapper.closeQuietly(response.body());
        }
        return result;
    }

    private void prepareOkHttpClientForPost(OkHttpClient.Builder okHttpClient, boolean gzip) {
        okHttpClient.followRedirects(false);
        if (gzip && okHttpClient.interceptors().size() > 0) {
            okHttpClient.interceptors().remove(0);
            okHttpClient.interceptors().add(0, new GzipRequestInterceptor(this));
        }
    }

    private void addRangeHeader(long rangeStart, long rangeEnd, Request.Builder builderRef) {
        if (rangeStart < 0L) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("bytes=");
        sb.append(rangeStart);
        sb.append('-');
        if (rangeEnd > 0L && rangeEnd > rangeStart) {
            sb.append(rangeEnd);
        }
        builderRef.addHeader("Range", sb.toString());
    }

    private Request.Builder prepareRequestBuilder(OkHttpClient.Builder okHttpClient, String url, int timeout2, String userAgent, String referrer, String cookie) {
        okHttpClient.connectTimeout(timeout2, TimeUnit.MILLISECONDS);
        okHttpClient.readTimeout(timeout2, TimeUnit.MILLISECONDS);
        okHttpClient.writeTimeout(timeout2, TimeUnit.MILLISECONDS);
        okHttpClient.interceptors().clear();
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (!StringUtils.isNullOrEmpty(userAgent)) {
            builder.header("User-Agent", userAgent);
        }
        if (!StringUtils.isNullOrEmpty(referrer)) {
            try {
                builder.header("Referer", referrer);
            }
            catch (IllegalArgumentException illegalEx) {
                LOG.info("Referer value: " + referrer);
                LOG.warn(illegalEx.getMessage(), illegalEx);
            }
        }
        if (!StringUtils.isNullOrEmpty(cookie)) {
            builder.header("Cookie", cookie);
        }
        return builder;
    }

    private void addCustomHeaders(Map<String, String> customHeaders, Request.Builder builder) {
        if (customHeaders != null && customHeaders.size() > 0) {
            try {
                for (Map.Entry<String, String> header : customHeaders.entrySet()) {
                    builder.header(header.getKey(), header.getValue());
                }
            }
            catch (Throwable e) {
                LOG.warn(e.getMessage(), e);
            }
        }
    }

    private Response getSyncResponse(OkHttpClient.Builder okHttpClient, Request.Builder builder) throws IOException {
        Request request = builder.build();
        return okHttpClient.build().newCall(request).execute();
    }

    private OkHttpClient.Builder newOkHttpClient() {
        return OkHttpClientWrapper.newOkHttpClient(this.pool);
    }

    class GzipRequestInterceptor
    implements Interceptor {
        GzipRequestInterceptor(OkHttpClientWrapper this$0) {
        }

        @Override
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            if (originalRequest.body() == null || originalRequest.header("Content-Encoding") != null) {
                return chain.proceed(originalRequest);
            }
            Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").method(originalRequest.method(), this.forceContentLength(this.gzip(originalRequest.body()))).build();
            return chain.proceed(compressedRequest);
        }

        private RequestBody forceContentLength(final RequestBody requestBody) throws IOException {
            final Buffer buffer = new Buffer();
            requestBody.writeTo(buffer);
            return new RequestBody(this){

                @Override
                public MediaType contentType() {
                    return requestBody.contentType();
                }

                @Override
                public long contentLength() {
                    return buffer.size();
                }

                @Override
                public void writeTo(BufferedSink sink2) throws IOException {
                    sink2.write(buffer.snapshot());
                }
            };
        }

        private RequestBody gzip(final RequestBody body) {
            return new RequestBody(this){

                @Override
                public MediaType contentType() {
                    return body.contentType();
                }

                @Override
                public long contentLength() {
                    return -1L;
                }

                @Override
                public void writeTo(BufferedSink sink2) throws IOException {
                    BufferedSink gzipSink = Okio.buffer(new GzipSink(sink2));
                    body.writeTo(gzipSink);
                    gzipSink.close();
                }
            };
        }
    }
}

