/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import com.frostwire.util.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public final class TaskThrottle {
    private static final boolean PROFILING_ENABLED = false;
    private static final Logger LOG = Logger.getLogger(TaskThrottle.class);
    private static final Hashtable<String, Long> asyncTaskSubmissionTimestampMap = new Hashtable();
    private static final Hashtable<String, Integer> tasksHitsMap = new Hashtable();
    private static final long RECYCLE_SUBMISSION_TIME_MAP_INTERVAL = 30000L;
    private static final long TASK_RECYCLE_INTERVAL_IN_MS = 10000L;
    private static long lastRecycleTimestamp = -1L;
    private static final Object recycleLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReadyToSubmitTask(String taskName, long minIntervalInMillis) {
        TaskThrottle.tryRecycling();
        long now = System.currentTimeMillis();
        if (!asyncTaskSubmissionTimestampMap.containsKey(taskName)) {
            Object object = recycleLock;
            synchronized (object) {
                asyncTaskSubmissionTimestampMap.put(taskName, now);
            }
            TaskThrottle.profileHit(taskName);
            return true;
        }
        long delta = now - asyncTaskSubmissionTimestampMap.get(taskName);
        if (delta >= minIntervalInMillis) {
            asyncTaskSubmissionTimestampMap.put(taskName, now);
            TaskThrottle.profileHit(taskName);
            return true;
        }
        return false;
    }

    public static long getLastSubmissionTimestamp(String taskName) {
        if (!asyncTaskSubmissionTimestampMap.containsKey(taskName)) {
            return -1L;
        }
        return asyncTaskSubmissionTimestampMap.get(taskName);
    }

    private static void profileHit(String taskName) {
    }

    private static void dumpTaskProfile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryRecycling() {
        if (asyncTaskSubmissionTimestampMap.size() == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastRecycleTimestamp > 30000L) {
            HashSet<String> taskNames;
            TaskThrottle.dumpTaskProfile();
            ArrayList<String> keysToRecycle = new ArrayList<String>();
            int numKeysBeforeRecycle = 0;
            Iterator iterator2 = recycleLock;
            synchronized (iterator2) {
                taskNames = new HashSet<String>(asyncTaskSubmissionTimestampMap.keySet());
            }
            for (String taskName : taskNames) {
                long delta;
                ++numKeysBeforeRecycle;
                Long submissionTimestamp = asyncTaskSubmissionTimestampMap.get(taskName);
                if (submissionTimestamp == null || (delta = now - submissionTimestamp) <= 10000L) continue;
                LOG.info("Recycling " + taskName + ", last used " + delta + " ms ago");
                keysToRecycle.add(taskName);
            }
            lastRecycleTimestamp = now;
            int numKeysToRecycle = keysToRecycle.size();
            double recycleRatio = 100 * numKeysToRecycle / numKeysBeforeRecycle;
            if (numKeysToRecycle > 0) {
                LOG.info("Recycling " + numKeysToRecycle + " tasks out of " + numKeysBeforeRecycle + " total tasks (freed  " + recycleRatio + "%)");
            }
            Object object = recycleLock;
            synchronized (object) {
                for (String task : keysToRecycle) {
                    try {
                        asyncTaskSubmissionTimestampMap.remove(task);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private static /* synthetic */ int lambda$dumpTaskProfile$0(Map.Entry o1, Map.Entry o2) {
        return Integer.compare((Integer)o1.getValue(), (Integer)o2.getValue());
    }
}

