/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.util;

import com.frostwire.util.ThreadPool;
import com.frostwire.util.http.HttpClient;
import com.frostwire.util.http.JdkHttpClient;
import com.frostwire.util.http.OkHttpClientWrapper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class HttpClientFactory {
    private static Map<HttpContext, ThreadPool> okHttpClientPools = null;
    private static final boolean FORCE_JDK_HTTP_CLIENT = false;
    private static final Map<HttpContext, OkHttpClientWrapper> fwOKHTTPClients = new HashMap<HttpContext, OkHttpClientWrapper>();
    private static final Object okHTTPClientLock = new Object();

    private HttpClientFactory() {
    }

    public static HttpClient newInstance() {
        return new JdkHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient getInstance(HttpContext context) {
        if (HttpClientFactory.isWindowsXP()) {
            return new JdkHttpClient();
        }
        if (okHttpClientPools == null) {
            okHttpClientPools = HttpClientFactory.buildThreadPools();
        }
        Object object = okHTTPClientLock;
        synchronized (object) {
            if (!fwOKHTTPClients.containsKey((Object)context)) {
                fwOKHTTPClients.put(context, new OkHttpClientWrapper(okHttpClientPools.get((Object)context)));
            }
        }
        return fwOKHTTPClients.get((Object)context);
    }

    private static Map<HttpContext, ThreadPool> buildThreadPools() {
        HashMap<HttpContext, ThreadPool> map = new HashMap<HttpContext, ThreadPool>();
        map.put(HttpContext.SEARCH, new ThreadPool("OkHttpClient-searches", 2, 2, 2L, new LinkedBlockingQueue<Runnable>(), true));
        map.put(HttpContext.DOWNLOAD, new ThreadPool("OkHttpClient-downloads", 2, 2, 2L, new LinkedBlockingQueue<Runnable>(), true));
        map.put(HttpContext.MISC, new ThreadPool("OkHttpClient-misc", 2, 2, 2L, new LinkedBlockingQueue<Runnable>(), true));
        return map;
    }

    private static boolean isWindowsXP() {
        String os = System.getProperty("os.name");
        os = os.toLowerCase(Locale.US);
        return os.contains("windows xp");
    }

    public static enum HttpContext {
        SEARCH,
        DOWNLOAD,
        MISC;

    }
}

