/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.transfers;

final class SpeedStat {
    private static final int INTERVAL_MILLISECONDS = 1000;
    private long totalBytes;
    private long averageSpeed;
    private long speedMarkTimestamp;
    private long lastTotalBytes;

    SpeedStat() {
    }

    private static long eta(double size, double total, double speed) {
        double left = size - total;
        if (left <= 0.0) {
            return 0L;
        }
        if (speed <= 0.0) {
            return -1L;
        }
        return (long)(left / speed);
    }

    private static int progress(double size, double total) {
        return size > 0.0 ? (int)(total * 100.0 / size) : 0;
    }

    long totalBytes() {
        return this.totalBytes;
    }

    long averageSpeed() {
        return this.averageSpeed;
    }

    public void update(long numBytes) {
        long now = System.currentTimeMillis();
        this.totalBytes += numBytes;
        if (now - this.speedMarkTimestamp > 1000L) {
            this.averageSpeed = (this.totalBytes - this.lastTotalBytes) * 1000L / (now - this.speedMarkTimestamp);
            this.speedMarkTimestamp = now;
            this.lastTotalBytes = this.totalBytes;
        }
    }

    long eta(double size) {
        return SpeedStat.eta(size, this.totalBytes, this.averageSpeed);
    }

    public int progress(double size) {
        return SpeedStat.progress(size, this.totalBytes);
    }
}

