/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.transfers;

import com.frostwire.platform.FileSystem;
import com.frostwire.platform.Platforms;
import com.frostwire.transfers.SpeedStat;
import com.frostwire.transfers.Transfer;
import com.frostwire.transfers.TransferItem;
import com.frostwire.transfers.TransferState;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.Logger;
import com.frostwire.util.ThreadPool;
import com.frostwire.util.http.HttpClient;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLException;
import org.apache.commons.io.FilenameUtils;

public abstract class BaseHttpDownload
implements Transfer {
    private static final Logger LOG = Logger.getLogger(BaseHttpDownload.class);
    private static final ExecutorService THREAD_POOL = ThreadPool.newThreadPool("HttpDownload", 20, true);
    protected final Info info;
    protected final File savePath;
    protected final File tempPath;
    protected final Date created;
    protected TransferState state;
    protected SpeedStat stat;
    protected boolean complete;

    protected BaseHttpDownload(Info info) {
        this.info = info;
        File saveDir = Platforms.data();
        File tempDir = Platforms.temp();
        FileSystem fs = Platforms.fileSystem();
        if (!fs.isDirectory(saveDir) && !fs.mkdirs(saveDir)) {
            this.complete(TransferState.ERROR_SAVE_DIR);
        }
        if (!fs.isDirectory(tempDir) && !fs.mkdirs(tempDir)) {
            this.complete(TransferState.ERROR_TEMP_DIR);
        }
        String filename = BaseHttpDownload.cleanupFilename(info.filename());
        this.savePath = BaseHttpDownload.buildFile(fs, saveDir, filename);
        this.tempPath = BaseHttpDownload.buildFile(fs, tempDir, filename);
        this.created = new Date();
        this.stat = new SpeedStat();
        this.state = TransferState.WAITING;
        this.complete = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void simpleHTTP(String url, OutputStream out, int timeout2) throws Throwable {
        URL u = new URI(url).toURL();
        URLConnection con = u.openConnection();
        con.setConnectTimeout(timeout2);
        con.setReadTimeout(timeout2);
        InputStream in = con.getInputStream();
        try {
            byte[] b = new byte[1024];
            int n = 0;
            while ((n = in.read(b, 0, b.length)) != -1) {
                out.write(b, 0, n);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Throwable throwable) {}
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
    }

    static File buildFile(FileSystem fs, File saveDir, String name) {
        String baseName = FilenameUtils.getBaseName(name);
        if (baseName.length() > 127) {
            baseName = baseName.substring(0, 127);
        }
        String ext = FilenameUtils.getExtension(name);
        File f = new File(saveDir, baseName + "." + ext);
        for (int i2 = 1; fs.exists(f) && i2 < 30; ++i2) {
            f = new File(saveDir, baseName + " (" + i2 + ")." + ext);
        }
        return f;
    }

    static String cleanupFilename(String filename) {
        filename = filename.replaceAll("[\\\\/:*?\"<>|\\[\\]]+", "_");
        return filename;
    }

    @Override
    public String getName() {
        return this.info.url();
    }

    @Override
    public String getDisplayName() {
        return this.info.displayName();
    }

    @Override
    public File getSavePath() {
        return this.savePath;
    }

    @Override
    public File previewFile() {
        return this.isComplete() ? this.savePath : null;
    }

    @Override
    public double getSize() {
        return this.info.size();
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public TransferState getState() {
        return this.state;
    }

    @Override
    public long getBytesReceived() {
        return this.stat.totalBytes();
    }

    @Override
    public long getBytesSent() {
        return 0L;
    }

    @Override
    public long getDownloadSpeed() {
        return this.complete ? 0L : this.stat.averageSpeed();
    }

    @Override
    public long getUploadSpeed() {
        return 0L;
    }

    @Override
    public boolean isDownloading() {
        return this.state == TransferState.DOWNLOADING;
    }

    @Override
    public long getETA() {
        return !this.complete ? this.stat.eta(this.info.size()) : 0L;
    }

    @Override
    public int getProgress() {
        return !this.complete ? this.stat.progress(this.info.size()) : 100;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public List<TransferItem> getItems() {
        return Collections.emptyList();
    }

    @Override
    public void remove(boolean deleteData) {
        if (this.complete) {
            return;
        }
        this.state = TransferState.CANCELED;
        this.complete(this.state);
        FileSystem fs = Platforms.fileSystem();
        if (fs.delete(this.tempPath)) {
            LOG.warn("Error deleting temporary file: " + String.valueOf(this.tempPath));
        }
        if (deleteData && fs.delete(this.savePath)) {
            LOG.warn("Error deleting download data file: " + String.valueOf(this.savePath));
        }
    }

    protected void start(final String url, final File temp, final boolean resume) {
        if (this.complete) {
            return;
        }
        THREAD_POOL.execute(new Thread(this.getDisplayName()){

            @Override
            public void run() {
                try {
                    if (BaseHttpDownload.this.complete) {
                        return;
                    }
                    BaseHttpDownload.this.state = TransferState.DOWNLOADING;
                    HttpClient client = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.DOWNLOAD);
                    client.setListener(new DownloadListener());
                    client.save(url, temp, resume);
                }
                catch (Throwable e) {
                    BaseHttpDownload.this.error(e);
                }
            }
        });
    }

    protected final void complete(TransferState state) {
        this.state = state;
        if (!this.complete) {
            this.complete = true;
            if (state == TransferState.COMPLETE) {
                try {
                    this.onComplete();
                }
                catch (Throwable e) {
                    this.error(e);
                }
            }
        }
    }

    protected final void finish() {
        if (this.complete) {
            return;
        }
        this.state = TransferState.FINISHING;
        THREAD_POOL.execute(() -> {
            try {
                if (this.complete) {
                    return;
                }
                this.onFinishing();
            }
            catch (Throwable e) {
                this.error(e);
            }
        });
    }

    protected final void error(Throwable e) {
        if (this.state != TransferState.CANCELED) {
            this.complete(TransferState.ERROR);
            LOG.error("General error in download " + String.valueOf(this.info), e);
            if (e.getMessage() != null && e.getMessage().contains("No space left on device")) {
                this.complete(TransferState.ERROR_DISK_FULL);
            }
            if (e instanceof SSLException || e instanceof SocketTimeoutException) {
                this.complete(TransferState.ERROR_CONNECTION_TIMED_OUT);
            }
            if (e instanceof UnknownHostException) {
                this.complete(TransferState.ERROR_NO_INTERNET);
            }
        }
    }

    protected void moveAndComplete(File src, File dst) {
        LOG.info("BaseHttpDownload::moveAndComplete from " + src.getAbsolutePath() + " to " + dst.getAbsolutePath());
        FileSystem fs = Platforms.fileSystem();
        if (fs.copy(src, dst)) {
            if (!fs.delete(src)) {
                LOG.warn("Error deleting source file while moving: " + String.valueOf(src));
            }
            this.state = TransferState.SCANNING;
            this.complete(TransferState.COMPLETE);
        } else {
            this.complete(TransferState.ERROR_MOVING_INCOMPLETE);
        }
    }

    protected void onHttpComplete() {
        this.finish();
    }

    protected void onFinishing() {
    }

    protected void onComplete() {
    }

    public static final class Info {
        private final String url;
        private final String filename;
        private final String displayName;
        private final double size;

        public Info(String url, String filename, String displayName, double size) {
            this.url = url;
            this.filename = filename;
            this.displayName = displayName;
            this.size = size;
        }

        public String url() {
            return this.url;
        }

        public String filename() {
            return this.filename;
        }

        public String displayName() {
            return this.displayName;
        }

        public double size() {
            return this.size;
        }

        public String toString() {
            return "{BaseHttpDownload.Info@" + this.hashCode() + " url=" + this.url + " filename=" + this.filename + " displayname=" + this.displayName + " size=" + this.size + "}";
        }
    }

    private final class DownloadListener
    extends HttpClient.HttpClientListenerAdapter {
        private DownloadListener() {
        }

        @Override
        public void onHeaders(HttpClient httpClient, Map<String, List<String>> headerFields) {
        }

        @Override
        public void onError(HttpClient client, Throwable e) {
            BaseHttpDownload.this.error(e);
        }

        @Override
        public void onData(HttpClient client, byte[] buffer, int offset, int length) {
            BaseHttpDownload.this.stat.update(length);
            if (BaseHttpDownload.this.complete) {
                throw new RuntimeException("Invalid status, transfer cancelled");
            }
        }

        @Override
        public void onComplete(HttpClient client) {
            try {
                BaseHttpDownload.this.onHttpComplete();
            }
            catch (Throwable e) {
                BaseHttpDownload.this.error(e);
            }
        }
    }
}

