/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.yify.YifySearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.StringUtils;
import com.frostwire.util.ThreadPool;
import com.frostwire.util.UrlUtils;
import com.frostwire.util.http.OkHttpClientWrapper;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class YifySearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(YifySearchPerformerTest.class);

    @Test
    public void yifiSearchTest() {
        String fileStr;
        String TEST_SEARCH_TERM = "one";
        String domain = "yts-movie.cc";
        String searchURL = "https://" + domain + "/search/" + TEST_SEARCH_TERM;
        OkHttpClientWrapper httpClient = new OkHttpClientWrapper(new ThreadPool("testPool", 4, new LinkedBlockingQueue<Runnable>(), false));
        try {
            LOG.info("Fething search results from " + searchURL + " ...");
            fileStr = httpClient.get(searchURL);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.fail(e.getMessage());
            return;
        }
        Pattern searchResultsDetailURLPattern = Pattern.compile("(?is)<a class=\"movielink\" href=\"/movie/(?<itemId>[0-9]*)/(?<htmlFileName>.*?)\" itemprop=\"name\">");
        Pattern detailPagePattern = Pattern.compile("(?is)<section id=\"(movie|torrent)\".*?<h1( itemprop=\"name\")?>(?<displayName>.*?)</h1>.*?<dt>Size:</dt>.*?<dd>(?<size>.*?)</dd>.*?Date:</dt>.*?(?<creationDate>[0-9]+/[0-9]+/[0-9]+.*?).*?</dd>.*?<dt>(Seeds|Seeders):</dt>.*?<dd>(?<seeds>[0-9]+).*?</dd>.*?<a href=\"(?<magnet>.*?)\" id=\"dm\" class=\"button button-default\".*?>Download Magnet</a>.*?");
        Matcher searchResultsMatcher = searchResultsDetailURLPattern.matcher(fileStr);
        int found = 0;
        while (searchResultsMatcher.find() && found < 5) {
            LOG.info("\nfound " + ++found);
            String detailUrl = "https://" + domain + "/torrent/" + searchResultsMatcher.group("itemId") + "/" + searchResultsMatcher.group("htmlFileName");
            long start = System.currentTimeMillis();
            String detailPage = null;
            try {
                detailPage = httpClient.get(detailUrl, 5000);
            }
            catch (IOException e) {
                e.printStackTrace();
                Assertions.fail(e.getMessage());
            }
            if (detailPage == null) {
                LOG.info("Error fetching from " + detailUrl);
                continue;
            }
            long downloadTime = System.currentTimeMillis() - start;
            LOG.info("Downloaded " + detailPage.length() + " bytes in " + downloadTime + "ms");
            SearchMatcher sm = new SearchMatcher(detailPagePattern.matcher(detailPage));
            if (sm.find()) {
                LOG.info("hash: [" + UrlUtils.extractInfoHash(sm.group("magnet")) + "]");
                LOG.info("size: [" + sm.group("size") + "]");
                Assertions.assertFalse(StringUtils.isNullOrEmpty(sm.group("displayName")), "displayName null or empty");
                Assertions.assertFalse(StringUtils.isNullOrEmpty(sm.group("creationDate")), "creationDate null or empty");
                Assertions.assertFalse(StringUtils.isNullOrEmpty(sm.group("seeds")), "seeds null or empty");
                Assertions.assertFalse(StringUtils.isNullOrEmpty(sm.group("magnet")), "magnet null or empty");
                YifySearchResult sr = new YifySearchResult(detailUrl, sm);
                LOG.info(sr.getDetailsUrl());
            } else {
                LOG.info("Detail page search matcher failed, check TORRENT_DETAILS_PAGE_REGEX");
                Assertions.fail("TORRENT_DETAILS_PAGE_REGEX broken");
            }
            LOG.info("===");
            LOG.info("Sleeping 4 seconds...");
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        LOG.info("-done-");
        if (found == 0) {
            LOG.info(fileStr);
            Assertions.fail("No search results");
        }
    }
}

