/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.torrentdownloads.TorrentDownloadsSearchPerformer;
import com.frostwire.search.torrentdownloads.TorrentDownloadsSearchResult;
import com.frostwire.search.torrentdownloads.TorrentDownloadsTempSearchResult;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.search.SearchEngine;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TorrentDownloadsSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(TorrentDownloadsSearchPerformerTest.class);

    @Test
    public void testTorrentDownloadsSearch() {
        final ArrayList searchResults = new ArrayList();
        final TorrentDownloadsSearchPerformer searchPerformer = (TorrentDownloadsSearchPerformer)SearchEngine.getSearchEngineByID(SearchEngine.SearchEngineID.TORRENTDOWNLOADS_ID).getPerformer(1L, "free");
        assert (searchPerformer != null);
        searchPerformer.setListener(new SearchListener(){

            @Override
            public void onResults(long token, List<? extends SearchResult> results) {
                LOG.info("[TorrentDownloadsSearchPerformerTest] onResults() " + results.size());
                for (SearchResult searchResult : results) {
                    if (searchResult instanceof TorrentDownloadsTempSearchResult) {
                        LOG.info("[TorrentDownloadsSearchPerformerTest] onResults() skipping temp result");
                        searchPerformer.crawl((CrawlableSearchResult)searchResult);
                        continue;
                    }
                    TorrentDownloadsSearchResult sr = (TorrentDownloadsSearchResult)searchResult;
                    LOG.info("[TorrentDownloadsSearchPerformerTest] onResults() hash = " + sr.getHash());
                    LOG.info("[TorrentDownloadsSearchPerformerTest] onResults() size = " + sr.getSize());
                    LOG.info("[TorrentDownloadsSearchPerformerTest] ==== ");
                    searchResults.add(sr);
                }
            }

            @Override
            public void onError(long token, SearchError error) {
            }

            @Override
            public void onStopped(long token) {
            }
        });
        searchPerformer.perform();
        Assertions.assertTrue(searchResults.size() > 0, "[TorrentDownloadsSearchPerformerTest] No results found using domain: " + searchPerformer.getDomainName());
    }
}

