/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.tpb.TPBSearchPerformer;
import com.frostwire.search.tpb.TPBSearchResult;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.search.SearchEngine;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TPBSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(TPBSearchPerformerTest.class);

    @Test
    public void testTPBSearch() {
        final ArrayList tpbResults = new ArrayList();
        TPBSearchPerformer tpbSearchPerformer = this.initializeSearchPerformer();
        assert (tpbSearchPerformer != null);
        tpbSearchPerformer.setListener(new SearchListener(){

            @Override
            public void onResults(long token, List<? extends SearchResult> results) {
                LOG.info("[TPBSearchPerformerTest] onResults() " + results.size());
                for (SearchResult searchResult : results) {
                    TPBSearchResult sr = (TPBSearchResult)searchResult;
                    LOG.info("[TPBSearchPerformerTest] onResults() size = " + sr.getSize());
                    LOG.info("[TPBSearchPerformerTest] onResults() hash = " + sr.getHash());
                    LOG.info("[TPBSearchPerformerTest] ==== ");
                    tpbResults.add(sr);
                }
            }

            @Override
            public void onError(long token, SearchError error) {
            }

            @Override
            public void onStopped(long token) {
            }
        });
        tpbSearchPerformer.perform();
        Assertions.assertTrue(tpbResults.size() > 0, "[TPBSearchPerformerTest] No results found using domain: " + tpbSearchPerformer.getDomainName());
    }

    private TPBSearchPerformer initializeSearchPerformer() {
        SearchEngine tpbEngine = SearchEngine.getSearchEngineByID(SearchEngine.SearchEngineID.TPB_ID);
        int wait = 250;
        int maxWait = 15000;
        int currentWait = 0;
        while (!tpbEngine.isReady() && currentWait < maxWait) {
            try {
                Thread.sleep(wait);
                currentWait += wait;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            LOG.info("[TPBSearchPerformerTest] Waiting " + currentWait + "ms for TPB engine to be ready...");
        }
        if (currentWait > maxWait) {
            LOG.error("TPB engine is not ready after " + maxWait + "ms");
            Assertions.fail("[TPBSearchPerformerTest] TPB engine is not ready after " + maxWait + "ms");
            return null;
        }
        if (tpbEngine.isReady()) {
            TPBSearchPerformer searchPerformer = (TPBSearchPerformer)tpbEngine.getPerformer(1337L, "free book");
            LOG.info("[TPBSearchPerformerTest] TPB engine is ready with domain: " + searchPerformer.getDomainName() + ", after " + currentWait + "ms");
            return searchPerformer;
        }
        return null;
    }
}

