/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.desktop.DesktopPlatform;
import com.frostwire.platform.Platforms;
import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.soundcloud.SoundcloudSearchPerformer;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.StringUtils;
import com.frostwire.util.UrlUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SoundcloudSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(SoundcloudSearchPerformerTest.class);

    @Test
    public void testSoundcloudSearchPerformer() {
        Platforms.set(new DesktopPlatform());
        String TEST_SEARCH_TERM = UrlUtils.encode("free download");
        SoundcloudSearchPerformer searchPerformer = new SoundcloudSearchPerformer("api-v2.sndcdn.com", 1L, TEST_SEARCH_TERM, 5000);
        SoundcloudSearchListener searchListener = new SoundcloudSearchListener();
        searchPerformer.setListener(searchListener);
        try {
            searchPerformer.perform();
            searchPerformer.stop();
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.info("Aborting test.");
            Assertions.fail(t.getMessage());
            return;
        }
        if (searchListener.failedTests.size() > 0) {
            Assertions.fail(searchListener.getFailedMessages());
        }
    }

    private static class SoundcloudSearchListener
    implements SearchListener {
        final List<String> failedTests = new ArrayList<String>();
        final List<SearchResult> searchResults = new ArrayList<SearchResult>();

        private SoundcloudSearchListener() {
        }

        @Override
        public void onResults(long token, List<? extends SearchResult> results) {
            if (results == null || results.size() == 0) {
                this.failedTests.add("No search results");
                return;
            }
            for (SearchResult searchResult : results) {
                SoundcloudSearchResult sr = (SoundcloudSearchResult)searchResult;
                LOG.info("SoundcloudSearchListener.SearchListener.onResults:");
                LOG.info("\t DisplayName: " + sr.getDisplayName());
                LOG.info("\t Source: " + sr.getSource());
                LOG.info("\t DetailsUrl: " + sr.getDetailsUrl());
                LOG.info("\t Filename: " + sr.getFilename());
                LOG.info("\t Hash: " + sr.getHash());
                LOG.info("\t DownloadUrl: " + sr.getDownloadUrl());
                LOG.info("\t Username: " + sr.getUsername());
                LOG.info("\t Size: " + sr.getSize());
                if (StringUtils.isNullOrEmpty(sr.getDisplayName())) {
                    this.failedTests.add("getDisplayName is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getSource())) {
                    this.failedTests.add("getSource is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getDetailsUrl())) {
                    this.failedTests.add("getDetailsUrl is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getFilename())) {
                    this.failedTests.add("getFilename is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getHash())) {
                    this.failedTests.add("getHash is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getDownloadUrl())) {
                    this.failedTests.add("getDownloadUrl is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getUsername())) {
                    this.failedTests.add("getUsername is null or empty");
                }
                if (this.failedTests.size() > 0) {
                    return;
                }
                this.searchResults.add(searchResult);
            }
        }

        @Override
        public void onError(long token, SearchError error) {
            this.failedTests.add(error.message());
        }

        @Override
        public void onStopped(long token) {
            if (this.searchResults.size() == 0) {
                this.failedTests.add("No search results");
            }
        }

        public String getFailedMessages() {
            if (this.failedTests.size() == 0) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            for (String msg : this.failedTests) {
                buffer.append(msg);
                buffer.append("\n");
            }
            return buffer.toString();
        }
    }
}

