/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.one337x.One337xSearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.StringUtils;
import com.frostwire.util.ThreadPool;
import com.frostwire.util.http.OkHttpClientWrapper;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class One337xSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(One337xSearchPerformerTest.class);

    @Test
    public void one377xSearchTest() {
        String TEST_SEARCH_TERM = "creative commons";
        OkHttpClientWrapper httpClient = new OkHttpClientWrapper(new ThreadPool("testPool", 4, new LinkedBlockingQueue<Runnable>(), false));
        String fileStr = null;
        try {
            fileStr = httpClient.get("https://www.1377x.to/search/" + TEST_SEARCH_TERM + "/1/");
        }
        catch (IOException e) {
            Assertions.fail(e.getMessage());
        }
        Pattern searchResultsDetailURLPattern = Pattern.compile("(?is)<a href=\"/torrent/(?<itemId>[0-9]*)/(?<htmlFileName>.*?)\">(?<displayName>.*?)</a>");
        Pattern detailPagePattern = Pattern.compile("(?is)<div class=\"box-info-heading clearfix\">.*?<a class=\".*\" href=\"(?<magnet>.*?)\" onclick=\".*\">.*?<strong>Language</strong>.*?<span>.*?</span>.*?<strong>Total size</strong>.*?<span>(?<size>.*?)</span>.*?<strong>Date uploaded</strong>.*?<span>(?<creationDate>.*?)</span>.*?<strong>Seeders</strong>.*?<span class=\"seeds\">(?<seeds>[0-9]+)</span>");
        Matcher searchResultsMatcher = searchResultsDetailURLPattern.matcher(fileStr);
        int found = 0;
        while (searchResultsMatcher.find() && found < 5) {
            LOG.info("\nfound " + ++found);
            LOG.info("result_url: [" + searchResultsMatcher.group(1) + "]");
            String detailUrl = "https://www.1377x.to/torrent/" + searchResultsMatcher.group("itemId") + "/" + searchResultsMatcher.group("htmlFileName");
            String displayName = searchResultsMatcher.group("displayName");
            long start = System.currentTimeMillis();
            String detailPage = null;
            try {
                detailPage = httpClient.get(detailUrl, 5000);
            }
            catch (IOException e) {
                Assertions.fail(e.getMessage());
            }
            if (detailPage == null) {
                Assertions.fail("Error fetching from " + detailUrl);
                continue;
            }
            long downloadTime = System.currentTimeMillis() - start;
            LOG.info("Downloaded " + detailPage.length() + " bytes in " + downloadTime + "ms");
            SearchMatcher sm = new SearchMatcher(detailPagePattern.matcher(detailPage));
            if (!sm.find()) {
                LOG.error("ERROR: Detail page search matcher failed, check TORRENT_DETAILS_PAGE_REGEX");
                LOG.error("HTML @ " + detailUrl + ":");
                LOG.error(detailPage);
                Assertions.fail("ERROR: Detail page search matcher failed, check TORRENT_DETAILS_PAGE_REGEX (" + detailUrl + ")");
                return;
            }
            Assertions.assertFalse(StringUtils.isNullOrEmpty(displayName), "displayName is null or empty");
            LOG.info("size: [" + sm.group("size") + "]");
            Assertions.assertFalse(StringUtils.isNullOrEmpty(sm.group("size")), "size is null or empty");
            LOG.info("creationDate: [" + sm.group("creationDate") + "]");
            Assertions.assertFalse(StringUtils.isNullOrEmpty(sm.group("creationDate")), "creationDate is null or empty");
            Assertions.assertFalse(StringUtils.isNullOrEmpty(sm.group("seeds")), "seeds is null or empty");
            Assertions.assertFalse(StringUtils.isNullOrEmpty(sm.group("magnet")), "magnet is null or empty");
            One337xSearchResult one337xSearchResult = new One337xSearchResult(detailUrl, displayName, sm);
            LOG.info("===");
            LOG.info("Sleeping 5 seconds...");
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        LOG.info("-done-");
        if (found == 0) {
            LOG.info(fileStr);
            Assertions.fail("No search results");
        }
    }
}

