/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.nyaa.NyaaSearchPerformer;
import com.frostwire.search.nyaa.NyaaSearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.UrlUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.limewire.util.StringUtils;

public class NyaaSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(NyaaSearchPerformerTest.class);

    @Test
    public void nyaaSearchPerformerTest() {
        String TEST_SEARCH_TERM = UrlUtils.encode("free");
        NyaaSearchPerformer nyaa = new NyaaSearchPerformer("nyaa.si", 1L, TEST_SEARCH_TERM, 5000);
        NyaaSearchListener listener = new NyaaSearchListener();
        nyaa.setListener(listener);
        try {
            nyaa.perform();
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (!nyaa.isDDOSProtectionActive()) {
                LOG.info("Aborting test.");
                Assertions.fail(t.getMessage());
            }
            return;
        }
        if (listener.failedTests.size() > 0 && !nyaa.isDDOSProtectionActive()) {
            Assertions.fail(listener.getFailedMessages());
        }
    }

    static class NyaaSearchListener
    implements SearchListener {
        final List<String> failedTests = new ArrayList<String>();

        NyaaSearchListener() {
        }

        @Override
        public void onResults(long token, List<? extends SearchResult> results) {
            if (results == null || results.size() == 0) {
                this.failedTests.add("no search results");
                return;
            }
            for (SearchResult searchResult : results) {
                NyaaSearchResult sr = (NyaaSearchResult)searchResult;
                LOG.info("NyaaSearchPerformer.SearchListener.onResults:");
                LOG.info("\t Hash: " + sr.getHash());
                LOG.info("\t Size: " + sr.getSize());
                if (StringUtils.isNullOrEmpty(sr.getDisplayName())) {
                    this.failedTests.add("getDisplayName() null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getSource())) {
                    this.failedTests.add("getSource() null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getDetailsUrl())) {
                    this.failedTests.add("getDetailsUrl() null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getFilename())) {
                    this.failedTests.add("getFilename() null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getHash())) {
                    this.failedTests.add("getHash() null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getTorrentUrl())) {
                    this.failedTests.add("getTorrentUrl() null or empty");
                }
                if (this.failedTests.size() <= 0) continue;
                return;
            }
        }

        @Override
        public void onError(long token, SearchError error) {
            this.failedTests.add(error.message());
        }

        @Override
        public void onStopped(long token) {
        }

        String getFailedMessages() {
            if (this.failedTests.size() == 0) {
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            for (String msg : this.failedTests) {
                buffer.append(msg);
                buffer.append("\n");
            }
            return buffer.toString();
        }
    }
}

