/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.magnetdl.MagnetDLSearchPerformer;
import com.frostwire.search.magnetdl.MagnetDLSearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.UrlUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.limewire.util.StringUtils;

public class MagnetDLTest {
    private static final Logger LOG = Logger.getLogger(MagnetDLTest.class);

    @Test
    public void main() {
        String TEST_SEARCH_TERM = UrlUtils.encode("creative commons");
        MagnetDLSearchPerformer magnetDLSearchPerformer = new MagnetDLSearchPerformer(1L, TEST_SEARCH_TERM, 5000);
        magnetDLSearchPerformer.setMinSeeds(0);
        MagnetDLSearchListener magnetDLSearchListener = new MagnetDLSearchListener();
        magnetDLSearchPerformer.setListener(magnetDLSearchListener);
        try {
            magnetDLSearchPerformer.perform();
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.info("Aborting test.");
            Assertions.fail(t.getMessage());
            return;
        }
        if (magnetDLSearchListener.failedTests.size() > 0) {
            Assertions.fail(magnetDLSearchListener.getFailedTestsMessages());
        }
        LOG.info("-done-");
    }

    static class MagnetDLSearchListener
    implements SearchListener {
        final List<String> failedTests = new ArrayList<String>();
        int totalResults = 0;

        MagnetDLSearchListener() {
        }

        @Override
        public void onResults(long token, List<? extends SearchResult> results) {
            if (results != null) {
                this.totalResults = results.size();
            }
            for (SearchResult searchResult : results) {
                MagnetDLSearchResult sr = (MagnetDLSearchResult)searchResult;
                LOG.info("MagnetDLSearchResult.SearchListener.onResults:");
                LOG.info("\t Size: " + sr.getSize());
                if (StringUtils.isNullOrEmpty(sr.getDisplayName())) {
                    this.failedTests.add("getDisplayName was null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getSource())) {
                    this.failedTests.add("getSource was null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getDetailsUrl())) {
                    this.failedTests.add("getDetailsUrl was null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getFilename())) {
                    this.failedTests.add("getFilename was null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getHash())) {
                    this.failedTests.add("getHash was null or empty");
                } else {
                    LOG.info("\t Hash: " + sr.getHash());
                }
                if (StringUtils.isNullOrEmpty(sr.getTorrentUrl())) {
                    this.failedTests.add("getHash was null or empty");
                }
                if (this.failedTests.size() <= 0 || results.size() >= 10) continue;
                return;
            }
        }

        @Override
        public void onError(long token, SearchError error) {
            if (this.totalResults == 0) {
                this.failedTests.add(error.message());
            }
        }

        @Override
        public void onStopped(long token) {
        }

        String getFailedTestsMessages() {
            if (this.failedTests.size() == 0) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            for (String msg : this.failedTests) {
                buffer.append(msg).append("\n");
            }
            return buffer.toString();
        }
    }
}

