/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.idope.IdopeSearchPerformer;
import com.frostwire.search.idope.IdopeSearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.StringUtils;
import com.frostwire.util.UrlUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IdopeSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(IdopeSearchPerformerTest.class);

    @Test
    public void iDopeTest() {
        LOG.info("IdopeSearchPerformerTests::iDopeTest() invoked");
        String TEST_SEARCH_TERM = UrlUtils.encode("creative commons");
        IdopeSearchPerformer idope = new IdopeSearchPerformer(1L, TEST_SEARCH_TERM, 5000);
        IdopeSearchListener searchListener = new IdopeSearchListener(idope);
        idope.setListener(searchListener);
        try {
            idope.perform();
            Assertions.assertEquals(searchListener.failedTests.size(), 0, searchListener.getFailedMessages());
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.info("Aborting test.");
            Assertions.fail(t.getMessage());
        }
        if (searchListener.failedTests.size() > 0) {
            Assertions.fail(searchListener.getFailedMessages());
        }
    }

    private static class IdopeSearchListener
    implements SearchListener {
        private final IdopeSearchPerformer performer;
        List<String> failedTests = new ArrayList<String>();

        public IdopeSearchListener(IdopeSearchPerformer performer) {
            this.performer = performer;
        }

        @Override
        public void onResults(long token, List<? extends SearchResult> results) {
            if (results == null || results.size() == 0) {
                if (!this.performer.isDDOSProtectionActive()) {
                    Assertions.fail("IdopeSearchPerformerTest: no search results");
                }
                return;
            }
            for (SearchResult searchResult : results) {
                IdopeSearchResult sr = (IdopeSearchResult)searchResult;
                LOG.info("IdopeSearchPerformer.SearchListener.onResults:");
                if (StringUtils.isNullOrEmpty(sr.getDisplayName())) {
                    this.failedTests.add("DisplayName was null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getSource())) {
                    this.failedTests.add("Source was null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getDetailsUrl())) {
                    this.failedTests.add("DetailsUrl was null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getFilename())) {
                    this.failedTests.add("Filename was null or empty");
                }
                LOG.info("\t Hash: " + sr.getHash());
                if (StringUtils.isNullOrEmpty(sr.getHash())) {
                    this.failedTests.add("Hash was null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getTorrentUrl())) {
                    this.failedTests.add("TorrentUrl was null or empty");
                }
                LOG.info("\t Size: " + sr.getSize());
                if (this.failedTests.size() <= 0) continue;
                return;
            }
        }

        @Override
        public void onError(long token, SearchError error) {
            this.failedTests.add("IdopeSearchPerformerTest: " + error.message());
        }

        @Override
        public void onStopped(long token) {
        }

        public String getFailedMessages() {
            if (this.failedTests.size() == 0) {
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            for (String errorMessage : this.failedTests) {
                buffer.append(errorMessage);
                buffer.append("\n");
            }
            return buffer.toString();
        }
    }
}

