/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.glotorrents.GloTorrentsSearchPerformer;
import com.frostwire.search.glotorrents.GloTorrentsSearchResult;
import com.frostwire.util.Logger;
import com.frostwire.util.StringUtils;
import com.frostwire.util.UrlUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GloTorrentsSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(GloTorrentsSearchPerformerTest.class);

    @Test
    public void testGloTorrentsSearchPerformerTest() {
        String TEST_SEARCH_TERM = UrlUtils.encode("new");
        GloTorrentsSearchPerformer searchPerformer = new GloTorrentsSearchPerformer(1L, TEST_SEARCH_TERM, 5000);
        GloTorrentsSearchListener searchListener = new GloTorrentsSearchListener();
        searchPerformer.setListener(searchListener);
        try {
            searchPerformer.perform();
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.info("Aborting test.");
            Assertions.fail(t.getMessage());
            return;
        }
        if (searchListener.failedTests.size() > 0) {
            Assertions.fail(searchListener.getFailedMessages());
        }
    }

    private static class GloTorrentsSearchListener
    implements SearchListener {
        final List<String> failedTests = new ArrayList<String>();

        private GloTorrentsSearchListener() {
        }

        @Override
        public void onResults(long token, List<? extends SearchResult> results) {
            if (results == null || results.size() == 0) {
                this.failedTests.add("No search results");
                return;
            }
            for (SearchResult searchResult : results) {
                GloTorrentsSearchResult sr = (GloTorrentsSearchResult)searchResult;
                LOG.info("GloTorrentsSearchListener.SearchListener.onResults:");
                LOG.info("\t Hash: " + sr.getHash());
                LOG.info("\t Seeds: " + sr.getSeeds());
                if (StringUtils.isNullOrEmpty(sr.getDisplayName())) {
                    this.failedTests.add("getDisplayName is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getSource())) {
                    this.failedTests.add("getSource is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getDetailsUrl())) {
                    this.failedTests.add("getDetailsUrl is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getFilename())) {
                    this.failedTests.add("getFilename is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getHash())) {
                    this.failedTests.add("getHash is null or empty");
                }
                if (StringUtils.isNullOrEmpty(sr.getTorrentUrl())) {
                    this.failedTests.add("getTorrentUrl is null or empty");
                }
                if (this.failedTests.size() <= 0) continue;
                return;
            }
        }

        @Override
        public void onError(long token, SearchError error) {
            this.failedTests.add(error.message());
        }

        @Override
        public void onStopped(long token) {
        }

        public String getFailedMessages() {
            if (this.failedTests.size() == 0) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            for (String msg : this.failedTests) {
                buffer.append(msg);
                buffer.append("\n");
            }
            return buffer.toString();
        }
    }
}

