/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.tests;

import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchResult;
import com.frostwire.search.btdigg.BTDiggSearchPerformer;
import com.frostwire.search.btdigg.BTDiggSearchResult;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.search.SearchEngine;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BTDiggSearchPerformerTest {
    private static final Logger LOG = Logger.getLogger(BTDiggSearchPerformerTest.class);

    @Test
    public void testSearch() {
        BTDiggSearchPerformer searchPerformer = (BTDiggSearchPerformer)SearchEngine.getSearchEngineByID(SearchEngine.SearchEngineID.BT_DIGG).getPerformer(1L, "creative commons");
        final ArrayList testResults = new ArrayList();
        searchPerformer.setListener(new SearchListener(){

            @Override
            public void onResults(long token, List<? extends SearchResult> results) {
                for (SearchResult searchResult : results) {
                    BTDiggSearchResult bsr = (BTDiggSearchResult)searchResult;
                    LOG.info("[BTDiggSearchPerformerTest] infoHash: " + bsr.getHash());
                    testResults.add((BTDiggSearchResult)searchResult);
                }
            }

            @Override
            public void onError(long token, SearchError error) {
            }

            @Override
            public void onStopped(long token) {
            }
        });
        searchPerformer.perform();
        Assertions.assertTrue(!searchPerformer.isDDOSProtectionActive() && testResults.size() > 0, "[BTDiggSearchPerformerTest] No results found");
    }
}

