/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.service;

import com.frostwire.service.MessageCallback;
import com.frostwire.service.Switch;

public class MessageService {
    private static volatile MessageCallback _callback = new ShellMessageService();

    private MessageService() {
    }

    public static MessageCallback getCallback() {
        return _callback;
    }

    public static void setCallback(MessageCallback callback) {
        _callback = callback;
    }

    public static void showError(String messageKey) {
        _callback.showError(messageKey);
    }

    public static void showError(String messageKey, Switch ignore) {
        _callback.showError(messageKey, ignore);
    }

    public static void showMessage(String messageKey) {
        _callback.showMessage(messageKey);
    }

    public static void showMessage(String messageKey, Switch ignore) {
        _callback.showMessage(messageKey, ignore);
    }

    public static void showFormattedMessage(String messageKey, Object ... args2) {
        _callback.showFormattedMessage(messageKey, args2);
    }

    public static void showFormattedMessage(String messageKey, Switch ignore, Object ... args2) {
        _callback.showFormattedMessage(messageKey, ignore, args2);
    }

    public static void showFormattedError(String errorKey, Object ... args2) {
        _callback.showFormattedError(errorKey, args2);
    }

    public static void showFormattedError(String errorKey, Switch ignore, Object ... args2) {
        _callback.showFormattedError(errorKey, ignore, args2);
    }

    private static final class ShellMessageService
    implements MessageCallback {
        private ShellMessageService() {
        }

        @Override
        public void showError(String messageKey) {
            System.out.println("error key: " + messageKey);
        }

        @Override
        public void showError(String messageKey, Switch ignore) {
            this.showError(messageKey);
        }

        @Override
        public void showMessage(String messageKey) {
            System.out.println("message key: " + messageKey);
        }

        @Override
        public void showMessage(String messageKey, Switch ignore) {
            this.showMessage(messageKey);
        }

        @Override
        public void showFormattedMessage(String messageKey, Object ... args2) {
            StringBuilder sb = new StringBuilder("message key: " + messageKey + " ");
            for (int i2 = 0; i2 < args2.length; ++i2) {
                sb.append("arg[").append(i2).append("]: ").append(args2[i2]);
                if (i2 >= args2.length - 1) continue;
                sb.append(", ");
            }
            System.out.println(sb);
        }

        @Override
        public void showFormattedMessage(String messageKey, Switch ignore, Object ... args2) {
            this.showFormattedMessage(messageKey, args2);
        }

        @Override
        public void showFormattedError(String errorKey, Object ... args2) {
            StringBuilder sb = new StringBuilder("error key: " + errorKey + " ");
            for (int i2 = 0; i2 < args2.length; ++i2) {
                sb.append("arg[").append(i2).append("]: ").append(args2[i2]);
                if (i2 >= args2.length - 1) continue;
                sb.append(", ");
            }
            System.out.println(sb);
        }

        @Override
        public void showFormattedError(String errorKey, Switch ignore, Object ... args2) {
            this.showFormattedError(errorKey, args2);
        }
    }
}

