/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.yt;

import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.search.PagedWebSearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.yt.YTSearchResult;
import com.frostwire.util.Logger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class YTSearchPerformer
extends PagedWebSearchPerformer {
    private static Pattern jsonPattern;
    private final Map<String, Integer> englishUnitsToSeconds = this.getEnglishUnitsToSeconds();
    private final Map<String, Integer> spanishUnitsToSeconds = this.getSpanishUnitsToSeconds();
    private final Map<String, Integer> germanUnitsToSeconds = this.getGermanUnitsToSeconds();
    private final Map<String, Integer> italianUnitsToSeconds = this.getItalianUnitsToSeconds();
    private final Map<String, Integer> frenchUnitsToSeconds = this.getFrenchUnitsToSeconds();
    private static final Logger LOG;

    public YTSearchPerformer(long token, String keywords, int timeout2, int pages) {
        super("www.youtube.com", token, keywords, timeout2, pages);
        if (jsonPattern == null) {
            jsonPattern = Pattern.compile("(\"videoRenderer\":.*?\"searchVideoResultEntityKey\")");
        }
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/results?search_query=" + encodedKeywords;
    }

    @Override
    protected List<? extends SearchResult> searchPage(String page) {
        Matcher jsonMatcher = jsonPattern.matcher(page);
        ArrayList<YTSearchResult> results = new ArrayList<YTSearchResult>();
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        while (jsonMatcher.find()) {
            try {
                Object json = jsonMatcher.group(1);
                json = ((String)json).replace("\"videoRenderer\":", "") + ":\"\"}";
                Video video = gson.fromJson((String)json, Video.class);
                if (video.publishedTimeText == null) continue;
                String title = video.title.runs.get((int)0).text;
                String videoAge = video.publishedTimeText.simpleText;
                long creationTimeInMillis = this.parseCreationTimeInMillis(videoAge);
                String thumbnailUrl = video.thumbnail.thumbnails.get((int)0).url;
                String detailsUrl = "https://" + this.getDomainName() + "/watch?v=" + video.videoId;
                long viewCount = 1000L + (video.viewCountText.simpleText.toLowerCase().contains("no views") ? 0L : Long.parseLong(video.viewCountText.simpleText.replace(",", "").replace(".", "").replace(" ", "").replaceAll("[a-zA-Z]+", "")));
                int viewCountInt = viewCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)viewCount;
                YTSearchResult searchResult = new YTSearchResult(title, detailsUrl, creationTimeInMillis, thumbnailUrl, viewCountInt, this.estimatedFileSize(video.lengthText.accessibility.accessibilityData.label));
                results.add(searchResult);
            }
            catch (Throwable e) {
                LOG.error("YTSearchPerformer() searchPage() error: " + e.getMessage(), e);
                LOG.error("YTSearchPerformer() searchPage() json: " + jsonMatcher.group(1));
            }
        }
        return results;
    }

    private long estimatedFileSize(String durationLabel) {
        String[] parts = durationLabel.replace("days", "day").replace("hours", "hour").replace("minutes", "minute").replace("seconds", "second").split(",");
        long seconds = 0L;
        for (String part : parts) {
            part = part.trim();
            String[] time = part.split(" ");
            int value = Integer.parseInt(time[0]);
            String unit = time[1];
            Integer mappedSeconds = this.englishUnitsToSeconds.getOrDefault(unit, null);
            if (mappedSeconds == null) {
                mappedSeconds = this.spanishUnitsToSeconds.getOrDefault(unit, null);
            }
            if (mappedSeconds == null) {
                mappedSeconds = this.germanUnitsToSeconds.getOrDefault(unit, null);
            }
            if (mappedSeconds == null) {
                mappedSeconds = this.italianUnitsToSeconds.getOrDefault(unit, null);
            }
            if (mappedSeconds == null) {
                mappedSeconds = this.frenchUnitsToSeconds.getOrDefault(unit, null);
            }
            if (mappedSeconds == null) {
                mappedSeconds = 1;
            }
            seconds += (long)value * (long)mappedSeconds.intValue();
        }
        long totalFrames = seconds * 30L;
        long bitDepth = 6L;
        long frameSize = 2073600L * bitDepth / 8192L;
        return totalFrames * frameSize;
    }

    private long parseCreationTimeInMillis(String creationString) {
        creationString = creationString.toLowerCase().replaceFirst("^\\D*", "");
        LOG.info("YTSearchPerformer() parseCreationTimeInMillis() creationString: " + creationString);
        Pattern pattern = Pattern.compile("(\\d+)\\s+([a-z\u00c3\u00b1]+)");
        Matcher matcher = pattern.matcher(creationString);
        if (matcher.find()) {
            int time = Integer.parseInt(matcher.group(1));
            String unit = matcher.group(2);
            Integer secondsPerUnit = this.englishUnitsToSeconds.getOrDefault(unit, null);
            if (secondsPerUnit == null) {
                secondsPerUnit = this.spanishUnitsToSeconds.getOrDefault(unit, null);
            }
            if (secondsPerUnit == null) {
                secondsPerUnit = this.germanUnitsToSeconds.getOrDefault(unit, null);
            }
            if (secondsPerUnit == null) {
                secondsPerUnit = this.italianUnitsToSeconds.getOrDefault(unit, null);
            }
            if (secondsPerUnit == null) {
                secondsPerUnit = this.frenchUnitsToSeconds.getOrDefault(unit, null);
            }
            if (secondsPerUnit != null) {
                return System.currentTimeMillis() - 1000L * (long)time * (long)secondsPerUnit.intValue();
            }
        }
        return System.currentTimeMillis();
    }

    private Map<String, Integer> getEnglishUnitsToSeconds() {
        HashMap<String, Integer> unitsToSeconds = new HashMap<String, Integer>();
        int minute = 60;
        int hour = 60 * minute;
        int day = 24 * hour;
        int week = 7 * day;
        int month = 30 * day;
        int year = 365 * day;
        unitsToSeconds.put("second", 1);
        unitsToSeconds.put("seconds", 1);
        unitsToSeconds.put("minute", minute);
        unitsToSeconds.put("minutes", minute);
        unitsToSeconds.put("hour", hour);
        unitsToSeconds.put("hours", hour);
        unitsToSeconds.put("day", day);
        unitsToSeconds.put("days", day);
        unitsToSeconds.put("week", week);
        unitsToSeconds.put("weeks", week);
        unitsToSeconds.put("month", month);
        unitsToSeconds.put("months", month);
        unitsToSeconds.put("year", year);
        unitsToSeconds.put("years", year);
        return unitsToSeconds;
    }

    private Map<String, Integer> getSpanishUnitsToSeconds() {
        HashMap<String, Integer> unitsToSeconds = new HashMap<String, Integer>();
        int minute = 60;
        int hour = 60 * minute;
        int day = 24 * hour;
        int week = 7 * day;
        int month = 30 * day;
        int year = 365 * day;
        unitsToSeconds.put("segundo", 1);
        unitsToSeconds.put("segundos", 1);
        unitsToSeconds.put("minuto", minute);
        unitsToSeconds.put("minutos", minute);
        unitsToSeconds.put("hora", hour);
        unitsToSeconds.put("horas", hour);
        unitsToSeconds.put("d\u00c3\u00ada", day);
        unitsToSeconds.put("d\u00c3\u00adas", day);
        unitsToSeconds.put("semana", week);
        unitsToSeconds.put("semanas", week);
        unitsToSeconds.put("mes", month);
        unitsToSeconds.put("meses", month);
        unitsToSeconds.put("a\u00c3\u00b1o", year);
        unitsToSeconds.put("a\u00c3\u00b1os", year);
        return unitsToSeconds;
    }

    private Map<String, Integer> getGermanUnitsToSeconds() {
        HashMap<String, Integer> unitsToSeconds = new HashMap<String, Integer>();
        int minute = 60;
        int hour = 60 * minute;
        int day = 24 * hour;
        int week = 7 * day;
        int month = 30 * day;
        int year = 365 * day;
        unitsToSeconds.put("sekunde", 1);
        unitsToSeconds.put("sekunden", 1);
        unitsToSeconds.put("minute", minute);
        unitsToSeconds.put("minuten", minute);
        unitsToSeconds.put("stunde", hour);
        unitsToSeconds.put("stunden", hour);
        unitsToSeconds.put("tag", day);
        unitsToSeconds.put("tage", day);
        unitsToSeconds.put("woche", week);
        unitsToSeconds.put("wochen", week);
        unitsToSeconds.put("monat", month);
        unitsToSeconds.put("monate", month);
        unitsToSeconds.put("jahr", year);
        unitsToSeconds.put("jahre", year);
        return unitsToSeconds;
    }

    private Map<String, Integer> getItalianUnitsToSeconds() {
        HashMap<String, Integer> unitsToSeconds = new HashMap<String, Integer>();
        int minute = 60;
        int hour = 60 * minute;
        int day = 24 * hour;
        int week = 7 * day;
        int month = 30 * day;
        int year = 365 * day;
        unitsToSeconds.put("secondo", 1);
        unitsToSeconds.put("secondi", 1);
        unitsToSeconds.put("minuto", minute);
        unitsToSeconds.put("minuti", minute);
        unitsToSeconds.put("ora", hour);
        unitsToSeconds.put("ore", hour);
        unitsToSeconds.put("giorno", day);
        unitsToSeconds.put("giorni", day);
        unitsToSeconds.put("settimana", week);
        unitsToSeconds.put("settimane", week);
        unitsToSeconds.put("mese", month);
        unitsToSeconds.put("mesi", month);
        unitsToSeconds.put("anno", year);
        unitsToSeconds.put("anni", year);
        return unitsToSeconds;
    }

    private Map<String, Integer> getFrenchUnitsToSeconds() {
        HashMap<String, Integer> unitsToSeconds = new HashMap<String, Integer>();
        int minute = 60;
        int hour = 60 * minute;
        int day = 24 * hour;
        int week = 7 * day;
        int month = 30 * day;
        int year = 365 * day;
        unitsToSeconds.put("seconde", 1);
        unitsToSeconds.put("secondes", 1);
        unitsToSeconds.put("minute", minute);
        unitsToSeconds.put("minutes", minute);
        unitsToSeconds.put("heure", hour);
        unitsToSeconds.put("heures", hour);
        unitsToSeconds.put("jour", day);
        unitsToSeconds.put("jours", day);
        unitsToSeconds.put("semaine", week);
        unitsToSeconds.put("semaines", week);
        unitsToSeconds.put("mois", month);
        unitsToSeconds.put("ann\u00c3\u00a9e", year);
        unitsToSeconds.put("ann\u00c3\u00a9es", year);
        return unitsToSeconds;
    }

    @Override
    public boolean isCrawler() {
        return false;
    }

    static {
        LOG = Logger.getLogger(YTSearchPerformer.class);
    }

    public static class Video {
        public String videoId;
        public Thumbnail thumbnail;
        public Title title;
        public PublishedTimeText publishedTimeText;
        public LengthText lengthText;
        public ViewCountText viewCountText;
    }

    public static class PublishedTimeText {
        public String simpleText;
    }

    public static class Title {
        public List<Runs> runs;
    }

    public static class Runs {
        public String text;
    }

    public static class Thumbnail {
        public List<ThumbnailDetails> thumbnails;
    }

    public static class ThumbnailDetails {
        public String url;
    }

    public static class ViewCountText {
        public String simpleText;
    }

    public static class LengthText {
        public Accessibility accessibility;
    }

    public static class Accessibility {
        public AccessibilityData accessibilityData;
    }

    public static class AccessibilityData {
        public String label;
    }
}

