/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.tpb;

import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class TPBSearchResult
extends AbstractTorrentSearchResult {
    private static final Map<String, String> UNIT_MAPPER = new HashMap<String, String>();
    private static final Pattern COMMON_DATE_PATTERN;
    private static final Pattern OLDER_DATE_PATTERN;
    private static final Pattern DATE_TIME_PATTERN;
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    TPBSearchResult(SearchMatcher matcher) {
        this.detailsUrl = matcher.group(2);
        String temp = HtmlManipulator.replaceHtmlEntities(matcher.group(3));
        temp = HtmlManipulator.replaceHtmlEntities(temp);
        this.filename = this.buildFilename(temp);
        this.displayName = FilenameUtils.getBaseName(this.filename);
        this.torrentUrl = matcher.group(4);
        this.infoHash = this.torrentUrl.substring(20, 60).toLowerCase();
        this.creationTime = this.parseCreationTime(matcher.group(5));
        this.size = this.parseSize(matcher.group(6));
        this.seeds = this.parseSeeds(matcher.group(7));
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "TPB";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    protected long parseSize(String group) {
        String[] size = group.split("&nbsp;");
        String amount = size[0].trim();
        String unit = UNIT_MAPPER.get(size[1].trim());
        return this.calculateSize(amount, unit);
    }

    private int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private long parseCreationTime(String group) {
        Matcher RIGHT_MATCHER;
        if (group.contains("Today") || group.contains("<b>")) {
            return System.currentTimeMillis();
        }
        if (group.contains("Y-day")) {
            return System.currentTimeMillis() - 86400000L;
        }
        Matcher OLDER_DATE_PATTERN_MATCHER = OLDER_DATE_PATTERN.matcher(group);
        Matcher COMMON_DATE_PATTERN_MATCHER = COMMON_DATE_PATTERN.matcher(group);
        Matcher DATE_TIME_PATTERN_MATCHER = DATE_TIME_PATTERN.matcher(group);
        Matcher matcher = RIGHT_MATCHER = OLDER_DATE_PATTERN_MATCHER.matches() ? OLDER_DATE_PATTERN_MATCHER : COMMON_DATE_PATTERN_MATCHER;
        if (!RIGHT_MATCHER.matches() && DATE_TIME_PATTERN_MATCHER.matches()) {
            RIGHT_MATCHER = DATE_TIME_PATTERN_MATCHER;
        }
        int month = Integer.parseInt(RIGHT_MATCHER.group(1));
        int date = Integer.parseInt(RIGHT_MATCHER.group(2));
        int year = 0;
        if (OLDER_DATE_PATTERN_MATCHER.matches() && OLDER_DATE_PATTERN_MATCHER.groupCount() == 3) {
            year = Integer.parseInt(RIGHT_MATCHER.group(3));
        } else if (COMMON_DATE_PATTERN_MATCHER.matches() || DATE_TIME_PATTERN_MATCHER.matches()) {
            year = Calendar.getInstance().get(1);
        }
        Calendar instance = Calendar.getInstance();
        instance.clear();
        instance.set(year, month, date);
        return instance.getTimeInMillis();
    }

    private String buildFilename(String filename) {
        return filename.replaceAll("[\\\\/:*?\"<>|\\[\\]]+", "_") + ".torrent";
    }

    static {
        UNIT_MAPPER.put("B", "B");
        UNIT_MAPPER.put("KiB", "KB");
        UNIT_MAPPER.put("MiB", "MB");
        UNIT_MAPPER.put("GiB", "GB");
        UNIT_MAPPER.put("TiB", "TB");
        UNIT_MAPPER.put("PiB", "PB");
        COMMON_DATE_PATTERN = Pattern.compile("([\\d]{2})-([\\d]{2})");
        OLDER_DATE_PATTERN = Pattern.compile("([\\d]{2})-([\\d]{2})&nbsp;([\\d]{4})");
        DATE_TIME_PATTERN = Pattern.compile("([\\d]{2})-([\\d]{2})&nbsp;(\\d\\d:\\d\\d)");
    }
}

