/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrentz2;

import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import com.frostwire.util.UrlUtils;
import org.apache.commons.io.FilenameUtils;

public final class Torrentz2SearchResult
extends AbstractTorrentSearchResult {
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    Torrentz2SearchResult(String detailsUrl, String infoHash, String filename, String fileSizeMagnitude, String fileSizeUnit, String ageString, int seeds, String trackers) {
        this.detailsUrl = detailsUrl;
        this.infoHash = infoHash;
        this.displayName = HtmlManipulator.replaceHtmlEntities(FilenameUtils.getBaseName(filename));
        String extension = FilenameUtils.getExtension(filename);
        this.filename = filename + "." + (extension.isEmpty() ? "torrent" : extension);
        this.size = this.parseSize(fileSizeMagnitude + " " + fileSizeUnit);
        this.creationTime = this.parseCreationTime(ageString);
        this.seeds = seeds;
        this.torrentUrl = UrlUtils.buildMagnetUrl(infoHash, filename, trackers);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "Torrentz2";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    private long parseCreationTime(String dateString) {
        long result = System.currentTimeMillis();
        try {
            String[] ds = dateString.split(" ");
            ds[1] = ds[1].toLowerCase();
            if (ds[1].contains("hour")) {
                try {
                    int hours = Integer.parseInt(ds[0]);
                    return result - (long)(hours * 60 * 60) * 1000L;
                }
                catch (Exception hours) {
                    // empty catch block
                }
            }
            if (ds[1].contains("year")) {
                try {
                    int years = Integer.parseInt(ds[0]);
                    return result - (long)years * 365L * 24L * 60L * 60L * 1000L;
                }
                catch (Exception years) {
                    // empty catch block
                }
            }
            if (ds[1].contains("month")) {
                try {
                    int months = Integer.parseInt(ds[0]);
                    return result - (long)months * 31L * 24L * 60L * 60L * 1000L;
                }
                catch (Exception months) {
                    // empty catch block
                }
            }
            if (ds[1].contains("week")) {
                try {
                    int weeks = Integer.parseInt(ds[0]);
                    return result - (long)weeks * 7L * 24L * 60L * 60L * 1000L;
                }
                catch (Exception weeks) {
                    // empty catch block
                }
            }
            if (ds[1].contains("day")) {
                try {
                    int days = Integer.parseInt(ds[0]);
                    return result - (long)days * 24L * 60L * 60L * 1000L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return result;
        }
    }
}

