/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.torrentdownloads;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.TorrentRegexCrawlerSearchPerformer;
import com.frostwire.search.torrentdownloads.TorrentDownloadsSearchResult;
import com.frostwire.search.torrentdownloads.TorrentDownloadsTempSearchResult;

public class TorrentDownloadsSearchPerformer
extends TorrentRegexCrawlerSearchPerformer<TorrentDownloadsSearchResult> {
    private static final int MAX_RESULTS = 20;
    private static final String PRELIMINARY_REGEX = "(?is)<a href=\"/torrent/([0-9]*?/.*?)\">*?";
    private static final String HTML_REGEX = "(?is).*?<li><a rel=\"nofollow\" href=\"http://itorrents.org/torrent/(?<torrentid>.*?).torrent?(.*?)\">.*?<span>Name:.?</span>(?<filename>.*?)(<a.*>)?</a></p></div>.*?<span>Total Size:.?</span>(?<filesize>.*?)&nbsp;(?<unit>[A-Z]+)</p></div>.*?<span>Magnet:.*?</span>.*?<a href=\"(?<magnet>.*?)\".*?<span>Seeds:.?</span>.?(?<seeds>\\d*?)</p></div>.*?<span>Torrent added:.?</span>.?(?<time>[0-9\\-]+).*</p></div>.*?";
    private boolean isDDOSProtectionActive;

    public TorrentDownloadsSearchPerformer(String domainName, long token, String keywords, int timeout2) {
        super(domainName, token, keywords, timeout2, 1, 40, 20, PRELIMINARY_REGEX, HTML_REGEX);
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        String transformedKeywords = encodedKeywords.replace("%20", "+");
        return "https://" + this.getDomainName() + "/search/?search=" + transformedKeywords;
    }

    @Override
    public CrawlableSearchResult fromMatcher(SearchMatcher matcher) {
        String itemId = matcher.group(1);
        return new TorrentDownloadsTempSearchResult(this.getDomainName(), itemId);
    }

    @Override
    protected int htmlPrefixOffset(String html) {
        int offset = html.indexOf("Torrent Search Results<span>");
        return Math.max(offset, 0);
    }

    @Override
    protected int htmlSuffixOffset(String html) {
        int offset = html.indexOf("<h1>RECENT SEARCHES");
        return Math.max(offset, 0);
    }

    @Override
    protected TorrentDownloadsSearchResult fromHtmlMatcher(CrawlableSearchResult sr, SearchMatcher matcher) {
        return new TorrentDownloadsSearchResult(this.getDomainName(), sr.getDetailsUrl(), matcher);
    }

    @Override
    protected boolean isValidHtml(String html) {
        this.isDDOSProtectionActive = html == null || html.contains("Cloudflare");
        return !this.isDDOSProtectionActive;
    }

    @Override
    public boolean isDDOSProtectionActive() {
        return this.isDDOSProtectionActive;
    }

    @Override
    public boolean isCrawler() {
        return true;
    }
}

