/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.telluride;

import com.frostwire.regex.Matcher;
import com.frostwire.regex.Pattern;
import com.frostwire.search.telluride.TellurideListener;

public final class TellurideParser {
    static final String DECIMAL_GROUP_FORMAT = "(?<%s>\\d{1,3}\\.\\d{1,3})";
    static final String ETA_GROUP = "(?<eta>\\d{1,3}\\:\\d{1,3})";
    static final String REGEX_PROGRESS = "(?is)" + String.format("(?<%s>\\d{1,3}\\.\\d{1,3})", "percentage") + "\\% of .*?" + String.format("(?<%s>\\d{1,3}\\.\\d{1,3})", "size") + "(?<unitSize>[KMGTP]iB) at.*?" + String.format("(?<%s>\\d{1,3}\\.\\d{1,3})", "rate") + "(?<unitRate>[KMGTP]iB/s) ETA (?<eta>\\d{1,3}\\:\\d{1,3})";
    static final Pattern downloadPattern = Pattern.compile(REGEX_PROGRESS);
    final TellurideListener processListener;
    final boolean metaOnly;
    final StringBuilder sb;

    TellurideParser(TellurideListener listener, boolean pMetaOnly) {
        this.processListener = listener;
        this.metaOnly = pMetaOnly;
        this.sb = new StringBuilder();
    }

    public void parse(String line) {
        if (line.contains("ERROR:")) {
            this.processListener.onError(line);
            return;
        }
        if (this.metaOnly) {
            this.sb.append(line);
        } else if (!line.isEmpty()) {
            if (line.startsWith("[download] Destination: ")) {
                this.processListener.onDestination(line.substring("[download] Destination: ".length()));
                return;
            }
            Matcher progressMatcher = downloadPattern.matcher(line);
            if (progressMatcher.find()) {
                String percentage = progressMatcher.group("percentage");
                String size = progressMatcher.group("size");
                String unitSize = progressMatcher.group("unitSize");
                String rate = progressMatcher.group("rate");
                String unitRate = progressMatcher.group("unitRate");
                String eta = progressMatcher.group("eta");
                this.processListener.onProgress(Float.parseFloat(percentage), Float.parseFloat(size), unitSize, Float.parseFloat(rate), unitRate, eta);
                return;
            }
        }
    }

    public void done() {
        if (this.metaOnly) {
            String JSON = this.sb.toString();
            if (JSON != null && JSON.length() > 0) {
                this.processListener.onMeta(JSON.substring(JSON.indexOf("{")));
            } else {
                this.processListener.onError("No metadata returned by telluride");
            }
        }
    }
}

