/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.telluride;

import com.frostwire.concurrent.concurrent.ThreadExecutor;
import com.frostwire.search.telluride.TellurideListener;
import com.frostwire.search.telluride.TellurideParser;
import com.frostwire.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class TellurideLauncher {
    private static final Logger LOG = Logger.getLogger(TellurideLauncher.class);

    public static void launch(File executable, String downloadUrl, File saveDirectory, boolean audioOnly, boolean metaOnly, boolean verboseOutput, TellurideListener processListener) {
        TellurideLauncher.checkExecutable(executable);
        ThreadExecutor.startThread(TellurideLauncher.launchRunnable(executable, downloadUrl, saveDirectory, audioOnly, metaOnly, verboseOutput, processListener), "telluride-process-adapter:" + downloadUrl);
    }

    private static void checkExecutable(File executable) {
        if (executable == null) {
            throw new IllegalArgumentException("TellurideLauncher::checkExecutable executable path is null, no telluride to launch");
        }
        if (!executable.isFile()) {
            throw new IllegalArgumentException("TellurideLauncher::checkExecutable " + String.valueOf(executable) + " is not a file");
        }
        if (!executable.canExecute()) {
            throw new IllegalArgumentException("TellurideLauncher::checkExecutable " + String.valueOf(executable) + " is not executable");
        }
    }

    private static Runnable launchRunnable(File executable, String downloadUrl, File saveDirectory, boolean audioOnly, boolean metaOnly, boolean verboseOutput, TellurideListener processListener) {
        return () -> {
            ProcessBuilder processBuilder = new ProcessBuilder(executable.getAbsolutePath(), downloadUrl);
            if (audioOnly) {
                processBuilder = new ProcessBuilder(executable.getAbsolutePath(), "-a", downloadUrl);
            }
            if (metaOnly) {
                processBuilder = new ProcessBuilder(executable.getAbsolutePath(), "-m", downloadUrl);
            }
            if (saveDirectory != null && saveDirectory.isDirectory() && saveDirectory.canWrite()) {
                processBuilder.directory(saveDirectory);
            }
            processBuilder.redirectErrorStream(true);
            try {
                String line;
                Process process = processBuilder.start();
                InputStream stdOut = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stdOut));
                TellurideParser parser = null;
                if (processListener != null) {
                    parser = new TellurideParser(processListener, metaOnly);
                }
                while ((line = reader.readLine()) != null) {
                    if (verboseOutput) {
                        System.out.println("TellurideLauncher::launchRunnable [" + executable.getName() + "] " + line);
                    }
                    if (processListener != null && processListener.aborted()) {
                        process.destroyForcibly();
                        break;
                    }
                    if (parser == null) continue;
                    parser.parse(line);
                }
                process.waitFor();
                if (verboseOutput) {
                    System.out.println("TellurideLauncher::launchRunnable Exit-Code: " + process.exitValue());
                }
                if (parser != null) {
                    parser.done();
                }
                if (processListener != null) {
                    processListener.onFinished(process.exitValue());
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
            }
        };
    }

    private static class TelluridePong {
        int build;
        String message;

        private TelluridePong() {
        }
    }
}

