/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.soundcloud;

import com.frostwire.platform.Platforms;
import com.frostwire.search.AbstractFileSearchResult;
import com.frostwire.search.HttpSearchResult;
import com.frostwire.search.StreamableSearchResult;
import com.frostwire.search.soundcloud.SoundcloudItem;
import com.frostwire.search.soundcloud.SoundcloudTrackURL;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.JsonUtils;
import com.frostwire.util.http.HttpClient;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class SoundcloudSearchResult
extends AbstractFileSearchResult
implements HttpSearchResult,
StreamableSearchResult {
    private static final String DATE_FORMAT = "yyyy/mm/dd HH:mm:ss Z";
    private final String displayName;
    private final String username;
    private final String trackUrl;
    private final String filename;
    private final String source;
    private final String thumbnailUrl;
    private final long date;
    private final String downloadUrl;
    private final String progressiveFormatJSONFetcherURL;
    private final long size;
    private final String hash;

    SoundcloudSearchResult(SoundcloudItem item, String clientId, String appVersion) {
        this.displayName = item.title;
        this.username = this.buildUsername(item);
        this.trackUrl = item.permalink_url;
        this.filename = item.permalink + "-soundcloud.mp3";
        this.size = this.buildSize(item);
        this.source = this.buildSource(item);
        String userAvatarUrl = null;
        if (item.user != null) {
            userAvatarUrl = item.user.avatar_url;
        }
        this.thumbnailUrl = this.buildThumbnailUrl(item.artwork_url != null ? item.artwork_url : userAvatarUrl);
        this.date = this.buildDate(item.created_at);
        this.progressiveFormatJSONFetcherURL = null != item.getProgressiveFormatJSONFetcherURL() ? item.getProgressiveFormatJSONFetcherURL() + "?client_id=" + clientId + "&app_version=" + appVersion : null;
        this.hash = Integer.toHexString(item.id * 953 * 631);
        this.downloadUrl = null;
    }

    public boolean fetchedDownloadUrl() {
        return this.downloadUrl != null;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.date;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getDetailsUrl() {
        return this.trackUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getStreamUrl() {
        return this.getDownloadUrl();
    }

    @Override
    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String getUsername() {
        return this.username;
    }

    @Override
    public String getDownloadUrl() {
        if (this.progressiveFormatJSONFetcherURL == null) {
            return null;
        }
        if (this.downloadUrl != null) {
            return this.downloadUrl;
        }
        if (Platforms.get().isUIThread()) {
            StackTraceElement[] stackTrace = new Exception().getStackTrace();
            int maxStackShow = 10;
            for (StackTraceElement e : stackTrace) {
                System.out.println(e.toString());
                if (--maxStackShow == 0) break;
            }
            throw new RuntimeException("SoundcloudSearchResult.getDownloadUrl(): Do not invoke getDownloadUrl() from the main thread if downloadUrl is null");
        }
        HttpClient client = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.DOWNLOAD);
        try {
            String json = client.get(this.progressiveFormatJSONFetcherURL);
            SoundcloudTrackURL soundcloudTrackURL = JsonUtils.toObject(json, SoundcloudTrackURL.class);
            if (soundcloudTrackURL != null && soundcloudTrackURL.url != null) {
                return soundcloudTrackURL.url;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
        return null;
    }

    private String buildUsername(SoundcloudItem item) {
        if (item.user != null && item.user.username != null) {
            return item.user.username;
        }
        return "";
    }

    private long buildSize(SoundcloudItem item) {
        int x = item.duration;
        int y = 128;
        return (long)x * (long)y / 8L;
    }

    private String buildSource(SoundcloudItem item) {
        if (item.user != null && item.user.username != null) {
            return "Soundcloud - " + item.user.username;
        }
        return "Soundcloud";
    }

    private String buildThumbnailUrl(String str) {
        String url = null;
        if (str != null) {
            try {
                url = str.substring(0, str.indexOf("-large.")) + "-t300x300.jpg";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return url;
    }

    private long buildDate(String str) {
        try {
            return new SimpleDateFormat(DATE_FORMAT, Locale.US).parse(str).getTime();
        }
        catch (Throwable e) {
            return System.currentTimeMillis();
        }
    }

    private String buildDownloadUrl(SoundcloudItem item, String clientId, String appVersion) {
        Object downloadUrl;
        String clientAppenderChar = item.download_url != null && item.download_url.contains("?") ? "&" : "?";
        Object object = downloadUrl = item.download_url != null ? item.download_url : item.stream_url;
        if (((String)downloadUrl).endsWith("/download")) {
            downloadUrl = ((String)downloadUrl).replace("/download", "/stream");
        }
        if (clientId != null && appVersion != null) {
            downloadUrl = (String)downloadUrl + clientAppenderChar + "client_id=" + clientId + "&app_version=" + appVersion;
        }
        return downloadUrl;
    }

    @Override
    public String toString() {
        return "SoundcloudSearchResult.getDisplayName(): " + this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SoundcloudSearchResult)) {
            return false;
        }
        SoundcloudSearchResult other = (SoundcloudSearchResult)o;
        return this.getDetailsUrl().equals(other.getDetailsUrl()) && this.getDisplayName().equals(other.getDisplayName()) && this.getHash().equals(other.getHash());
    }

    public int hashCode() {
        return this.getHash().hashCode();
    }

    public String getHash() {
        return this.hash;
    }
}

