/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.soundcloud;

import com.frostwire.search.PagedWebSearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.soundcloud.SoundcloudItem;
import com.frostwire.search.soundcloud.SoundcloudPlaylist;
import com.frostwire.search.soundcloud.SoundcloudResponse;
import com.frostwire.search.soundcloud.SoundcloudSearchResult;
import com.frostwire.util.JsonUtils;
import java.util.LinkedList;
import java.util.List;

public final class SoundcloudSearchPerformer
extends PagedWebSearchPerformer {
    private static final String SOUNDCLOUD_CLIENTID = "RMDIzNoU4QIzQsT3xq9J5TdxFFQlJvLY";
    private static final String SOUNDCLOUD_APP_VERSION = "1660231961";

    public SoundcloudSearchPerformer(String domainName, long token, String keywords, int timeout2) {
        super(domainName, token, keywords, timeout2, 1);
    }

    public static String resolveUrl(String url) {
        return "https://api-v2.soundcloud.com/resolve?url=" + url + "&client_id=RMDIzNoU4QIzQsT3xq9J5TdxFFQlJvLY&app_version=1660231961";
    }

    public static LinkedList<SoundcloudSearchResult> fromJson(String json, boolean fromPastedUrl) {
        LinkedList<SoundcloudSearchResult> r = new LinkedList<SoundcloudSearchResult>();
        if (json.contains("\"collection\":")) {
            SoundcloudResponse obj = JsonUtils.toObject(json, SoundcloudResponse.class);
            if (obj != null && obj.collection != null) {
                obj.collection.stream().filter(SoundcloudItem::isValidSearchResult).forEach(item -> r.add(new SoundcloudSearchResult((SoundcloudItem)item, SOUNDCLOUD_CLIENTID, SOUNDCLOUD_APP_VERSION)));
            }
        } else if (json.contains("\"tracks\":")) {
            SoundcloudPlaylist obj = JsonUtils.toObject(json, SoundcloudPlaylist.class);
            if (obj != null && obj.tracks != null) {
                obj.tracks.stream().filter(SoundcloudItem::isValidSearchResult).forEach(item -> r.add(new SoundcloudSearchResult((SoundcloudItem)item, SOUNDCLOUD_CLIENTID, SOUNDCLOUD_APP_VERSION)));
            }
        } else {
            SoundcloudItem item2 = JsonUtils.toObject(json, SoundcloudItem.class);
            if (item2 != null && item2.isValidSearchResult(fromPastedUrl)) {
                SoundcloudSearchResult sr = new SoundcloudSearchResult(item2, SOUNDCLOUD_CLIENTID, SOUNDCLOUD_APP_VERSION);
                r.add(sr);
            }
        }
        return r;
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        return "https://api-v2.soundcloud.com/search/tracks?q=" + encodedKeywords + "&limit=50&offset=0&client_id=RMDIzNoU4QIzQsT3xq9J5TdxFFQlJvLY";
    }

    @Override
    protected List<? extends SearchResult> searchPage(String page) {
        LinkedList result = new LinkedList();
        SoundcloudResponse obj = JsonUtils.toObject(page, SoundcloudResponse.class);
        if (obj != null && obj.collection != null) {
            obj.collection.stream().filter(item -> !this.isStopped() && item.isValidSearchResult()).forEach(item -> result.add(new SoundcloudSearchResult((SoundcloudItem)item, SOUNDCLOUD_CLIENTID, SOUNDCLOUD_APP_VERSION)));
        }
        return result;
    }

    @Override
    public boolean isCrawler() {
        return false;
    }
}

