/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.magnetdl;

import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class MagnetDLSearchResult
extends AbstractTorrentSearchResult {
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    MagnetDLSearchResult(String detailsUrl, String magnet, String fileSize, String unit, String age, String seeds, String title) {
        this.detailsUrl = detailsUrl;
        this.torrentUrl = magnet + "&tr=udp://tracker.leechers-paradise.org:6969/announce&tr=udp://tracker.coppersurfer.tk:6969/announce&tr=udp://tracker.internetwarriors.net:1337/announce&tr=udp://retracker.akado-ural.ru:80/announce&tr=udp://tracker.moeking.me:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://retracker.baikal-telecom.net:2710/announce&tr=udp://bt.dy20188.com:80/announce&tr=udp://tracker.nyaa.uk:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://amigacity.xyz:6969/announce&tr=udp://tracker.supertracker.net:1337/announce&tr=udp://tracker.cyberia.is:6969/announce&tr=udp://tracker.openbittorrent.com:80/announce&tr=udp://tracker.msm8916.com:6969/announce&tr=udp://tracker.sktorrent.net:6969/announce&";
        this.infoHash = magnet.substring(20, 60);
        this.filename = this.parseFileName(title);
        this.size = this.parseSize(fileSize + " " + unit);
        this.creationTime = this.parseAgeString(age);
        this.seeds = this.parseSeeds(seeds);
        this.displayName = title;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "MagnetDL";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    private String parseFileName(String decodedFileName) {
        return HtmlManipulator.replaceHtmlEntities(decodedFileName.trim()) + ".torrent";
    }

    private int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private long parseAgeString(String dateString) {
        long now = System.currentTimeMillis();
        try {
            if (dateString.contains("year")) {
                int years = Integer.parseInt(dateString.substring(0, dateString.indexOf(32)));
                long yearInMillis = 31536000000L;
                return now - (long)years * yearInMillis;
            }
            if (dateString.contains("month")) {
                int months = Integer.parseInt(dateString.substring(0, dateString.indexOf(32)));
                long monthInMillis = 2678400000L;
                return now - (long)months * monthInMillis;
            }
            if (dateString.contains("day")) {
                int days = Integer.parseInt(dateString.substring(0, dateString.indexOf(32)));
                long dayInMillis = 86400000L;
                return now - (long)days * dayInMillis;
            }
            if (dateString.contains("hour")) {
                int hours = Integer.parseInt(dateString.substring(0, dateString.indexOf(32)));
                long hourInMillis = 3600000L;
                return now - (long)hours * hourInMillis;
            }
            if (dateString.contains("Yesterday")) {
                return now - 86400000L;
            }
            SimpleDateFormat myFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            now = myFormat.parse(dateString.trim()).getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return now;
    }
}

