/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.limetorrents;

import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import com.frostwire.util.UrlUtils;
import java.text.SimpleDateFormat;
import java.util.Locale;

public final class LimeTorrentsSearchResult
extends AbstractTorrentSearchResult {
    private final String filename;
    private final String displayName;
    private final String detailsUrl;
    private final String torrentUrl;
    private final String infoHash;
    private final long size;
    private final long creationTime;
    private final int seeds;

    LimeTorrentsSearchResult(String detailsUrl, String infoHash, String filename, String fileSize, String unit, String age, String seeds, String title) {
        this.detailsUrl = detailsUrl;
        this.infoHash = infoHash == null ? null : infoHash.toLowerCase();
        this.filename = this.parseFileName(filename);
        this.size = this.parseSize(fileSize + " " + unit);
        this.creationTime = this.parseAgeString(age);
        this.seeds = this.parseSeeds(seeds);
        this.torrentUrl = UrlUtils.buildMagnetUrl(infoHash, filename, "tr=udp://tracker.leechers-paradise.org:6969/announce&tr=udp://tracker.coppersurfer.tk:6969/announce&tr=udp://tracker.internetwarriors.net:1337/announce&tr=udp://retracker.akado-ural.ru:80/announce&tr=udp://tracker.moeking.me:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://retracker.baikal-telecom.net:2710/announce&tr=udp://bt.dy20188.com:80/announce&tr=udp://tracker.nyaa.uk:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://amigacity.xyz:6969/announce&tr=udp://tracker.supertracker.net:1337/announce&tr=udp://tracker.cyberia.is:6969/announce&tr=udp://tracker.openbittorrent.com:80/announce&tr=udp://tracker.msm8916.com:6969/announce&tr=udp://tracker.sktorrent.net:6969/announce&");
        this.displayName = title;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        return "LimeTorrents";
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    private String parseFileName(String decodedFileName) {
        return HtmlManipulator.replaceHtmlEntities(decodedFileName.trim()) + ".torrent";
    }

    private int parseSeeds(String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private long parseAgeString(String dateString) {
        long now = System.currentTimeMillis();
        try {
            if (dateString.contains("1 Year+")) {
                return now - 31536000000L;
            }
            if (dateString.contains("Last Month")) {
                return now - 2678400000L;
            }
            if (dateString.contains("months ago")) {
                int months = Integer.parseInt(dateString.substring(0, dateString.indexOf(32)));
                long monthInMillis = 2678400000L;
                return now - (long)months * monthInMillis;
            }
            if (dateString.contains("days ago")) {
                int days = Integer.parseInt(dateString.substring(0, dateString.indexOf(32)));
                long dayInMillis = 86400000L;
                return now - (long)days * dayInMillis;
            }
            if (dateString.contains("Yesterday")) {
                return now - 86400000L;
            }
            SimpleDateFormat myFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
            now = myFormat.parse(dateString.trim()).getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return now;
    }
}

