/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.limetorrents;

import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.limetorrents.LimeTorrentsSearchResult;
import com.frostwire.search.torrent.SimpleTorrentSearchPerformer;
import com.frostwire.util.Logger;
import java.util.ArrayList;
import java.util.List;

public class LimeTorrentsSearchPerformer
extends SimpleTorrentSearchPerformer {
    private static final Logger LOG = Logger.getLogger(LimeTorrentsSearchPerformer.class);
    private static Pattern pattern;

    public LimeTorrentsSearchPerformer(String domainName, long token, String keywords, int timeout2) {
        super(domainName, token, keywords, timeout2, 1, 1);
        if (pattern == null) {
            pattern = Pattern.compile("(?is)<div class=\"tt-name\"><a href=\"http://itorrents.org/torrent/(?<infohash>.*?)\\.torrent\\?title=(?<filename>.*?)\" rel=\"nofollow\" class=\"csprite_dl14\"></a><a href=\"/(?<detailUrl>.*?.html)\">(?<title>.*?)</.*?<div class=\"tt-options\"></div></td>.*?<td class=\"tdnormal\">(?<age>.*?) -.*?</a></td>.*?<td class=\"tdnormal\">(?<fileSizeMagnitude>.*?) (?<fileSizeUnit>[A-Z]+)</td>.*?<td class=\"tdseed\">(?<seeds>.*?)</td>.*?");
        }
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        String transformedKeywords = encodedKeywords.replace("%20", "-");
        return "https://" + this.getDomainName() + "/search/all/" + transformedKeywords + "/leechs/1/";
    }

    protected List<LimeTorrentsSearchResult> searchPage(String page) {
        boolean matcherFound;
        String HTML_PREFIX_MARKER = "Health</th>";
        int htmlPrefixIndex = page.indexOf("Health</th>") + "Health</th>".length();
        String HTML_SUFFIX_MARKER = "Next page";
        int htmlSuffixIndex = page.indexOf("Next page");
        String reducedHtml = page.substring(htmlPrefixIndex, htmlSuffixIndex > 0 ? htmlSuffixIndex : page.length() - htmlPrefixIndex);
        ArrayList<LimeTorrentsSearchResult> results = new ArrayList<LimeTorrentsSearchResult>(0);
        SearchMatcher matcher = new SearchMatcher(pattern.matcher(reducedHtml));
        int MAX_RESULTS = 50;
        do {
            try {
                matcherFound = matcher.find();
            }
            catch (Throwable t) {
                matcherFound = false;
                LOG.error("searchPage() has failed.\n" + t.getMessage(), t);
            }
            if (matcherFound) {
                LimeTorrentsSearchResult sr = this.fromMatcher(matcher);
                if (sr.getSeeds() > 0) {
                    results.add(sr);
                }
                LOG.info("Adding a new search result -> " + sr.getDisplayName() + ":" + sr.getSize() + ":" + sr.getTorrentUrl());
                continue;
            }
            LOG.warn("LimeTorrentsSearchPerformer::searchPage(String page): search matcher broken. Please notify at https://github.com/frostwire/frostwire/issues/new");
            LOG.warn("========");
            LOG.warn(page);
            LOG.warn("========");
        } while (matcherFound && !this.isStopped() && results.size() <= MAX_RESULTS);
        return results;
    }

    private LimeTorrentsSearchResult fromMatcher(SearchMatcher matcher) {
        String infoHash = matcher.group("infohash");
        String detailsURL = "https://" + this.getDomainName() + "/" + matcher.group("detailUrl");
        String filename = matcher.group("filename");
        String title = matcher.group("title");
        String ageString = matcher.group("age");
        String fileSizeMagnitude = matcher.group("fileSizeMagnitude");
        String fileSizeUnit = matcher.group("fileSizeUnit");
        String seeds = matcher.group("seeds");
        return new LimeTorrentsSearchResult(detailsURL, infoHash, filename, fileSizeMagnitude, fileSizeUnit, ageString, seeds, title);
    }

    @Override
    public boolean isCrawler() {
        return false;
    }
}

