/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.idope;

import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.idope.IdopeSearchResult;
import com.frostwire.search.torrent.SimpleTorrentSearchPerformer;
import com.frostwire.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IdopeSearchPerformer
extends SimpleTorrentSearchPerformer {
    private static final Logger LOG = Logger.getLogger(IdopeSearchPerformer.class);
    private static Pattern pattern;
    private boolean isDDOSProtectionActive;

    public IdopeSearchPerformer(long token, String keywords, int timeout2) {
        super("idope.se", token, keywords, timeout2, 1, 0);
        if (pattern == null) {
            pattern = Pattern.compile("(?is)<img class=\"resultdivtopimg\".*?<a href=\"/torrent/(?<keyword>.*?)/(?<infohash>.*?)/\".*?<div  class=\"resultdivtopname\" >[\n][\\s|\t]+(?<filename>.*?)</div>.*?<div class=\"resultdivbottontime\">(?<age>.*?)</div>.*?<div class=\"resultdivbottonlength\">(?<filesize>.*?)\\p{Z}(?<unit>.*?)</div>.*?<div class=\"resultdivbottonseed\">(?<seeds>.*?)</div>");
        }
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/torrent-list/" + encodedKeywords;
    }

    private IdopeSearchResult fromMatcher(SearchMatcher matcher) {
        String infoHash = matcher.group("infohash");
        String detailsURL = "https://" + this.getDomainName() + "/torrent/" + matcher.group("keyword") + "/" + infoHash;
        String filename = matcher.group("filename");
        String fileSizeMagnitude = matcher.group("filesize");
        String fileSizeUnit = matcher.group("unit");
        String ageString = matcher.group("age");
        int seeds = Integer.parseInt(matcher.group("seeds"));
        return new IdopeSearchResult(detailsURL, infoHash, filename, fileSizeMagnitude, fileSizeUnit, ageString, seeds, "tr=udp://tracker.leechers-paradise.org:6969/announce&tr=udp://tracker.coppersurfer.tk:6969/announce&tr=udp://tracker.internetwarriors.net:1337/announce&tr=udp://retracker.akado-ural.ru:80/announce&tr=udp://tracker.moeking.me:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://retracker.baikal-telecom.net:2710/announce&tr=udp://bt.dy20188.com:80/announce&tr=udp://tracker.nyaa.uk:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://amigacity.xyz:6969/announce&tr=udp://tracker.supertracker.net:1337/announce&tr=udp://tracker.cyberia.is:6969/announce&tr=udp://tracker.openbittorrent.com:80/announce&tr=udp://tracker.msm8916.com:6969/announce&tr=udp://tracker.sktorrent.net:6969/announce&");
    }

    protected List<? extends IdopeSearchResult> searchPage(String page) {
        boolean matcherFound;
        if (null == page || page.isEmpty()) {
            this.stopped = true;
            return Collections.emptyList();
        }
        String HTML_PREFIX_MARKER = "<div id=\"div2child\">";
        int htmlPrefixIndex = page.indexOf("<div id=\"div2child\">") + "<div id=\"div2child\">".length();
        String HTML_SUFFIX_MARKER = "<div id=\"rightdiv\">";
        int htmlSuffixIndex = page.indexOf("<div id=\"rightdiv\">");
        String reducedHtml = page.substring(htmlPrefixIndex, htmlSuffixIndex > 0 ? htmlSuffixIndex : page.length() - htmlPrefixIndex);
        ArrayList<IdopeSearchResult> results = new ArrayList<IdopeSearchResult>(0);
        SearchMatcher matcher = new SearchMatcher(pattern.matcher(reducedHtml));
        int MAX_RESULTS = 10;
        do {
            try {
                matcherFound = matcher.find();
            }
            catch (Throwable t) {
                matcherFound = false;
                LOG.error("searchPage() has failed.\n" + t.getMessage(), t);
            }
            if (matcherFound) {
                IdopeSearchResult sr = this.fromMatcher(matcher);
                results.add(sr);
                continue;
            }
            this.isDDOSProtectionActive = reducedHtml.contains("Cloudflare");
            if (!this.isDDOSProtectionActive) {
                LOG.warn("IdopeSearchPerformer search matcher broken. Please notify at https://github.com/frostwire/frostwire/issues/new");
                continue;
            }
            LOG.warn("IdopeSearchPerformer search matcher disabled. DDOS protection active.");
        } while (matcherFound && !this.isStopped() && results.size() < MAX_RESULTS);
        return results;
    }

    @Override
    public boolean isDDOSProtectionActive() {
        return this.isDDOSProtectionActive;
    }

    @Override
    public boolean isCrawler() {
        return false;
    }
}

