/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.glotorrents;

import com.frostwire.regex.Pattern;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.SearchResult;
import com.frostwire.search.glotorrents.GloTorrentsSearchResult;
import com.frostwire.search.torrent.SimpleTorrentSearchPerformer;
import com.frostwire.util.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GloTorrentsSearchPerformer
extends SimpleTorrentSearchPerformer {
    private static final Logger LOG = Logger.getLogger(GloTorrentsSearchPerformer.class);
    private static Pattern pattern;

    public GloTorrentsSearchPerformer(long token, String keywords, int timeoutMillis) {
        super("www.gtdb.to", token, keywords, timeoutMillis, 1, 0);
        if (pattern == null) {
            pattern = Pattern.compile("(?is)<td class='ttable_col2' nowrap='nowrap'>.*?<a title=\"(?<filename>.*?)\" href=\"(?<detailsURL>.*?)\"><b>.*?'nofollow' href=\"(?<magnet>.*?)\">.*?\"Magnet Download\".*?<td class='ttable_col1' align='center'>(?<filesize>\\d+\\.\\d+)\\p{Z}(?<unit>[KMGTP]B)</td>(.|\\n)*?<font color='green'><b>(?<seeds>.*?)</b></font>");
        }
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        return "https://www.gtdb.to/search_results.php?search=" + encodedKeywords + "&cat=0&incldead=0&lang=0&sort=seeders&order=desc";
    }

    private GloTorrentsSearchResult fromMatcher(SearchMatcher matcher) {
        String filename = matcher.group("filename");
        String detailsURL = "https://" + this.getDomainName() + matcher.group("detailsURL");
        String magnetURL = matcher.group("magnet");
        int magnetStart = "magnet:?xt=urn:btih:".length();
        String infoHash = magnetURL.substring(magnetStart, magnetStart + 40);
        String fileSizeMagnitude = matcher.group("filesize");
        String fileSizeUnit = matcher.group("unit");
        int seeds = Integer.parseInt(matcher.group("seeds").replace(",", ""));
        return new GloTorrentsSearchResult(magnetURL, detailsURL, infoHash, filename, fileSizeMagnitude, fileSizeUnit, seeds, "tr=udp://tracker.leechers-paradise.org:6969/announce&tr=udp://tracker.coppersurfer.tk:6969/announce&tr=udp://tracker.internetwarriors.net:1337/announce&tr=udp://retracker.akado-ural.ru:80/announce&tr=udp://tracker.moeking.me:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://retracker.baikal-telecom.net:2710/announce&tr=udp://bt.dy20188.com:80/announce&tr=udp://tracker.nyaa.uk:6969/announce&tr=udp://carapax.net:6969/announce&tr=udp://amigacity.xyz:6969/announce&tr=udp://tracker.supertracker.net:1337/announce&tr=udp://tracker.cyberia.is:6969/announce&tr=udp://tracker.openbittorrent.com:80/announce&tr=udp://tracker.msm8916.com:6969/announce&tr=udp://tracker.sktorrent.net:6969/announce&");
    }

    @Override
    protected List<? extends SearchResult> searchPage(String page) {
        boolean matcherFound;
        if (null == page || page.isEmpty()) {
            this.stopped = true;
            return Collections.emptyList();
        }
        String HTML_PREFIX_MARKER = "class=\"ttable_headinner\"";
        int htmlPrefixIndex = page.indexOf("class=\"ttable_headinner\"") + "class=\"ttable_headinner\"".length();
        String HTML_SUFFIX_MARKER = "<div class=\"pagination\">";
        int htmlSuffixIndex = page.indexOf("<div class=\"pagination\">");
        String reducedHtml = page.substring(htmlPrefixIndex, htmlSuffixIndex > 0 ? htmlSuffixIndex : page.length() - htmlPrefixIndex);
        ArrayList<GloTorrentsSearchResult> results = new ArrayList<GloTorrentsSearchResult>(0);
        SearchMatcher matcher = new SearchMatcher(pattern.matcher(reducedHtml));
        int MAX_RESULTS = 10;
        do {
            try {
                matcherFound = matcher.find();
            }
            catch (Throwable t) {
                matcherFound = false;
                LOG.error("searchPage() has failed.\n" + t.getMessage(), t);
            }
            if (matcherFound) {
                GloTorrentsSearchResult sr = this.fromMatcher(matcher);
                results.add(sr);
                continue;
            }
            LOG.warn("GloTorrentsSearchResult search matcher broken. Please notify at https://github.com/frostwire/frostwire/issues/new");
        } while (matcherFound && !this.isStopped() && results.size() < MAX_RESULTS);
        return results;
    }

    @Override
    public boolean isCrawler() {
        return false;
    }
}

