/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.eztv;

import com.frostwire.regex.Pattern;
import com.frostwire.search.PerformersHelper;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.eztv.EztvSearchResult;
import com.frostwire.search.torrent.SimpleTorrentSearchPerformer;
import com.frostwire.util.Logger;
import java.util.ArrayList;
import java.util.List;

public class EztvSearchPerformer
extends SimpleTorrentSearchPerformer {
    private static final Logger LOG = Logger.getLogger(EztvSearchPerformer.class);
    private static Pattern searchPattern = null;
    private boolean isDDOSProtectionActive;

    public EztvSearchPerformer(String domainName, long token, String keywords, int timeout2) {
        super(domainName, token, keywords, timeout2, 1, 0);
        if (searchPattern == null) {
            searchPattern = Pattern.compile("(?is)<td class=\"forum_thread_post\">\\s+<a href=\"(?<detailUrl>.*?)\" title=\"(?<displayname>.*?)\" alt=\".*?\" class=\"epinfo\".*?<a href=\"magnet(?<magnet>.*?)\" class=\"magnet\".*?</td>.*?<td align=\"center\" class=\"forum_thread_post\">(?<size>[0-9\\. GMB]+)</td>.*?<td align=\"center\" class=\"forum_thread_post\">(?<age>.*?)</td>");
        }
    }

    @Override
    protected String getSearchUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/search/" + encodedKeywords;
    }

    protected List<EztvSearchResult> searchPage(String page) {
        String reducedPage;
        if (page == null || page.isEmpty() || !this.isValidHtml(page)) {
            return new ArrayList<EztvSearchResult>();
        }
        int startOffset = page.indexOf("Seeds");
        int endOffset = page.indexOf("<img src=\"//ezimg.ch/s/1/2/ssl.png");
        if (startOffset > 0 && endOffset > 0 && endOffset > startOffset) {
            reducedPage = page.substring(startOffset, endOffset);
        } else {
            LOG.warn("EztvSearchPerformer()::searchPage() could not reduce page");
            reducedPage = page;
        }
        SearchMatcher matcher = new SearchMatcher(searchPattern.matcher(reducedPage));
        ArrayList<EztvSearchResult> results = new ArrayList<EztvSearchResult>();
        List<String> searchTokens = PerformersHelper.tokenizeSearchKeywords(this.getKeywords());
        int MAX_RESULTS = 75;
        int maxFailures = 10;
        boolean matcherFound = false;
        do {
            try {
                matcherFound = matcher.find();
            }
            catch (Throwable t) {
                LOG.error("EztvSearchPerformer.searchPage() has failed.\n" + t.getMessage(), t);
                LOG.error("EztvSearchPerformer.searchPage() reduced page:\n" + reducedPage + "\n");
            }
            if (matcherFound) {
                try {
                    EztvSearchResult sr = new EztvSearchResult(this.getDomainName(), matcher);
                    if (!PerformersHelper.someSearchTokensMatchSearchResult(searchTokens, sr)) continue;
                    results.add(sr);
                }
                catch (Throwable t) {
                    LOG.error(t.getMessage(), t);
                }
                continue;
            }
            --maxFailures;
        } while (maxFailures > 0 && !this.isStopped() && results.size() <= MAX_RESULTS);
        if (results.isEmpty()) {
            LOG.error("EztvSearchPerformer()::searchPage() no matches found for pattern");
            if (maxFailures == 0) {
                LOG.warn("EztvSearchPerformer search matcher broken on " + this.getDomainName() + ". Please notify at https://github.com/frostwire/frostwire/issues/new");
                LOG.warn("EztvSearchPerformer trying to search with regex: [" + searchPattern.toString() + "]");
            }
        }
        return results;
    }

    protected boolean isValidHtml(String html) {
        if (html == null || html.contains("Cloudflare Ray")) {
            this.isDDOSProtectionActive = true;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDDOSProtectionActive() {
        return this.isDDOSProtectionActive;
    }

    @Override
    public boolean isCrawler() {
        return false;
    }
}

