/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.btdigg;

import com.frostwire.search.SearchMatcher;
import com.frostwire.search.torrent.AbstractTorrentSearchResult;
import com.frostwire.util.HtmlManipulator;
import com.frostwire.util.UrlUtils;

public class BTDiggSearchResult
extends AbstractTorrentSearchResult {
    private final String detailsUrl;
    private final String displayName;
    private final String torrentUrl;
    private final String filename;
    private final String infoHash;
    private final int seeds;
    private final long size;

    BTDiggSearchResult(String domainName, SearchMatcher matcher) {
        this.detailsUrl = matcher.group("detailUrl");
        this.displayName = HtmlManipulator.replaceHtmlEntities(matcher.group("displayName")).trim().replaceAll("\\<.*?\\>", "");
        this.torrentUrl = matcher.group("magnet");
        this.filename = this.displayName + ".torrent";
        this.infoHash = UrlUtils.extractInfoHash(this.torrentUrl);
        this.seeds = 500;
        this.size = this.parseSize(matcher.group("size").replace('\u00a0', ' '));
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDetailsUrl() {
        return this.detailsUrl;
    }

    @Override
    public String getSource() {
        return "BTDigg";
    }

    @Override
    public String getTorrentUrl() {
        return this.torrentUrl;
    }

    @Override
    public int getSeeds() {
        return this.seeds;
    }

    @Override
    public String getHash() {
        return this.infoHash;
    }
}

