/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.archiveorg;

import com.frostwire.search.AbstractCrawledSearchResult;
import com.frostwire.search.HttpSearchResult;
import com.frostwire.search.archiveorg.ArchiveorgFile;
import com.frostwire.search.archiveorg.ArchiveorgSearchResult;
import com.frostwire.util.UrlUtils;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public class ArchiveorgCrawledSearchResult
extends AbstractCrawledSearchResult
implements HttpSearchResult {
    private static final String DOWNLOAD_URL = "https://%s/download/%s/%s";
    private final String filename;
    private final String displayName;
    private final String downloadUrl;
    private final long size;

    public ArchiveorgCrawledSearchResult(ArchiveorgSearchResult sr, ArchiveorgFile file) {
        super(sr);
        this.filename = FilenameUtils.getName(file.filename);
        this.displayName = FilenameUtils.getBaseName(this.filename) + " (" + sr.getDisplayName() + ")";
        this.downloadUrl = String.format(Locale.US, DOWNLOAD_URL, sr.getDomainName(), sr.getIdentifier(), UrlUtils.encode(file.filename));
        this.size = this.calcSize(file);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    private long calcSize(ArchiveorgFile file) {
        try {
            return Long.parseLong(file.size);
        }
        catch (Throwable e) {
            return -1L;
        }
    }
}

