/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.search.SearchResult;
import com.frostwire.search.WebSearchPerformer;
import com.frostwire.util.Logger;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public abstract class PagedWebSearchPerformer
extends WebSearchPerformer {
    private static final Logger LOG = Logger.getLogger(PagedWebSearchPerformer.class);
    private final int pages;

    public PagedWebSearchPerformer(String domainName, long token, String keywords, int timeout2, int pages) {
        super(domainName, token, keywords, timeout2);
        this.pages = pages;
    }

    @Override
    public void perform() {
        for (int i2 = 1; !this.isStopped() && i2 <= this.pages; ++i2) {
            List<? extends SearchResult> searchResults = this.searchPage(i2);
            if (searchResults == null || searchResults.isEmpty()) continue;
            this.onResults(searchResults);
        }
    }

    protected List<? extends SearchResult> searchPage(int page) {
        List<Object> result = Collections.emptyList();
        String url = null;
        try {
            url = this.getSearchUrl(page, this.getEncodedKeywords());
            String text = this.fetchSearchPage(url);
            if (text != null) {
                result = this.searchPage(text);
            }
        }
        catch (Throwable e) {
            if (url == null) {
                url = "n.a";
            }
            if (e instanceof SSLPeerUnverifiedException) {
                LOG.error("Make sure to add " + this.getDomainName() + " to Ssl.FWHostnameVerifier valid host name list");
            }
            LOG.error("Error searching page [" + url + "]: " + e.getMessage(), e);
        }
        return result;
    }

    protected String fetchSearchPage(String url) throws IOException {
        return this.fetch(url);
    }

    protected abstract String getSearchUrl(int var1, String var2);

    protected abstract List<? extends SearchResult> searchPage(String var1);
}

