/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.content.ContentValues;
import com.frostwire.content.Context;
import com.frostwire.database.Cursor;
import com.frostwire.database.sqlite.SQLiteDatabase;
import com.frostwire.database.sqlite.SQLiteOpenHelper;
import com.frostwire.database.sqlite.SQLiteQueryBuilder;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public final class CrawlCacheDB {
    private static final Logger LOG = Logger.getLogger(CrawlCacheDB.class);
    private static final String DATABASE_NAME = "crawldb";
    private static final int DATABASE_VERSION = 2;
    private static final String TABLE_NAME = "cache_data";
    private static final String DEFAULT_SORT_ORDER = "date_added DESC";
    private static final CrawlCacheDB instance = new CrawlCacheDB();
    private final DatabaseHelper databaseHelper = new DatabaseHelper(new Context());

    private CrawlCacheDB() {
    }

    public static CrawlCacheDB instance() {
        return instance;
    }

    public Cursor query(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        qb.setTables(TABLE_NAME);
        String orderBy = StringUtils.isEmpty(sortOrder) ? DEFAULT_SORT_ORDER : sortOrder;
        SQLiteDatabase db = this.databaseHelper.getReadableDatabase();
        return qb.query(db, projection, selection, selectionArgs, null, null, orderBy);
    }

    public long insert(ContentValues initialValues) {
        ContentValues values2 = initialValues != null ? new ContentValues(initialValues) : new ContentValues();
        Long now = System.currentTimeMillis() / 1000L;
        if (!values2.containsKey("date_added")) {
            values2.put("date_added", now);
        }
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        return db.insert(TABLE_NAME, "", values2);
    }

    public int delete(String where, String[] whereArgs) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        return db.delete(TABLE_NAME, where, whereArgs);
    }

    void truncate() {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        db.execSQL("DELETE FROM cache_data");
    }

    public int update(ContentValues values2, String where, String[] whereArgs) {
        SQLiteDatabase db = this.databaseHelper.getWritableDatabase();
        return db.update(TABLE_NAME, values2, where, whereArgs);
    }

    long sizeInBytes() {
        return this.databaseHelper.sizeInBytes();
    }

    public static final class Columns {
        public static final String ID = "id";
        public static final String DATA = "data";
        static final String KEY = "key";
        static final String DATE_ADDED = "date_added";

        private Columns() {
        }
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context context) {
            super(context, CrawlCacheDB.DATABASE_NAME, 2, null);
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            if (SearchSettings.SMART_SEARCH_DATABASE_FOLDER.getValue().exists()) {
                try {
                    FileUtils.deleteDirectory(SearchSettings.SMART_SEARCH_DATABASE_FOLDER.getValue());
                }
                catch (IOException e) {
                    LOG.warn("Unable to delete old smart search database");
                }
            }
            db.execSQL("CREATE TABLE cache_data (id INTEGER PRIMARY KEY,key VARCHAR,data BLOB,date_added INTEGER);");
            db.execSQL("CREATE INDEX idx_cache_data_id ON cache_data (id)");
            db.execSQL("CREATE INDEX idx_cache_data_key ON cache_data (key)");
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            LOG.warn("Upgrading documents database from version " + oldVersion + " to " + newVersion + ", which will destroy all old data");
            db.execSQL("DROP TABLE IF EXISTS cache_data");
            this.onCreate(db);
        }
    }
}

