/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.platform;

import com.frostwire.platform.FileFilter;
import com.frostwire.platform.FileSystem;
import com.frostwire.platform.Platforms;
import com.frostwire.util.Logger;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;

public class DefaultFileSystem
implements FileSystem {
    private static final Logger LOG = Logger.getLogger(DefaultFileSystem.class);

    public static void walkFiles(FileSystem fs, File file, FileFilter filter) {
        File[] arr = fs.listFiles(file, filter);
        if (arr == null) {
            return;
        }
        LinkedList<File> q = new LinkedList<File>(Arrays.asList(arr));
        while (!q.isEmpty()) {
            File child = (File)q.pollFirst();
            filter.file(child);
            if (!fs.isDirectory(child) || (arr = fs.listFiles(child, filter)) == null) continue;
            for (int i2 = arr.length - 1; i2 >= 0; --i2) {
                q.addFirst(arr[i2]);
            }
        }
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    @Override
    public boolean isFile(File file) {
        return file.isFile();
    }

    @Override
    public boolean canRead(File file) {
        return file.canRead();
    }

    @Override
    public boolean canWrite(File file) {
        return file.canWrite();
    }

    @Override
    public long length(File file) {
        return file.length();
    }

    @Override
    public long lastModified(File file) {
        return file.lastModified();
    }

    @Override
    public boolean exists(File file) {
        return file.exists();
    }

    @Override
    public boolean mkdirs(File file) {
        return file.mkdirs();
    }

    @Override
    public boolean delete(File file) {
        return file.delete();
    }

    @Override
    public File[] listFiles(File file, FileFilter filter) {
        return file.listFiles(filter);
    }

    @Override
    public boolean copy(File src, File dest) {
        try {
            FileUtils.copyFile(src, dest);
            LOG.info("Success: DefaultFileSystem.copy(src=" + String.valueOf(src) + ", dest=" + String.valueOf(dest) + ")");
            return true;
        }
        catch (Throwable e) {
            LOG.error("Error in copy file: " + String.valueOf(src) + " -> " + String.valueOf(dest), e);
            return false;
        }
    }

    @Override
    public boolean write(File file, byte[] data) {
        try {
            FileUtils.writeByteArrayToFile(file, data);
            return true;
        }
        catch (Throwable e) {
            LOG.error("Error in writing to file: " + String.valueOf(file), e);
            return false;
        }
    }

    @Override
    public void walk(File file, FileFilter filter) {
        DefaultFileSystem.walkFiles(Platforms.fileSystem(), file, filter);
    }
}

