/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.platform;

import com.frostwire.platform.AppSettings;
import com.frostwire.platform.FileSystem;
import com.frostwire.platform.Platform;
import com.frostwire.platform.SystemPaths;

public abstract class AbstractPlatform
implements Platform {
    private final FileSystem fileSystem;
    private final SystemPaths systemPaths;
    private final AppSettings appSettings;

    public AbstractPlatform(FileSystem fileSystem, SystemPaths systemPaths, AppSettings appSettings) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("FileSystem can't be null");
        }
        if (systemPaths == null) {
            throw new IllegalArgumentException("SystemPaths can't be null");
        }
        if (appSettings == null) {
            throw new IllegalArgumentException("AppSettings can't be null");
        }
        this.fileSystem = fileSystem;
        this.systemPaths = systemPaths;
        this.appSettings = appSettings;
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public SystemPaths systemPaths() {
        return this.systemPaths;
    }

    @Override
    public AppSettings appSettings() {
        return this.appSettings;
    }
}

