/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mplayer;

import com.frostwire.mplayer.IcyInfoListener;
import com.frostwire.mplayer.Language;
import com.frostwire.mplayer.LanguageSource;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.mplayer.MediaPlayer;
import com.frostwire.mplayer.MetaDataListener;
import com.frostwire.mplayer.PlayerPreferences;
import com.frostwire.mplayer.PositionListener;
import com.frostwire.mplayer.StateListener;
import com.frostwire.mplayer.TaskListener;
import com.frostwire.mplayer.VolumeListener;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseMediaPlayer
implements MediaPlayer,
MetaDataListener,
StateListener,
VolumeListener,
PositionListener,
TaskListener,
IcyInfoListener {
    private final List<MetaDataListener> metaDataListeners;
    private final List<StateListener> stateListeners;
    private final List<VolumeListener> volumeListeners;
    private final List<PositionListener> positionListeners;
    private final List<TaskListener> taskListeners;
    private final List<IcyInfoListener> icyInfoListeners;
    protected final PlayerPreferences preferences;
    private MediaPlaybackState currentState;
    private int currentVolume;
    private float currentPositionInSecs;
    private float durationInSecs;
    private final Object audioTracksLock = new Object();
    private final Object subtitlesLock = new Object();
    private List<Language> audioTracks;
    private List<Language> subtitles;
    private String openedFile;

    protected BaseMediaPlayer(PlayerPreferences preferences) {
        this.preferences = preferences;
        this.metaDataListeners = new ArrayList<MetaDataListener>(1);
        this.stateListeners = new ArrayList<StateListener>(1);
        this.volumeListeners = new ArrayList<VolumeListener>(1);
        this.positionListeners = new ArrayList<PositionListener>(1);
        this.taskListeners = new ArrayList<TaskListener>(1);
        this.icyInfoListeners = new ArrayList<IcyInfoListener>(1);
        this.initialize();
        this.setMetaDataListener(this);
        this.setStateListener(this);
        this.setVolumeListener(this);
        this.setPositionListener(this);
        this.setIcyInfoListener(this);
    }

    private void initialize() {
        this.openedFile = null;
        this.audioTracks = new ArrayList<Language>();
        this.subtitles = new ArrayList<Language>();
        this.durationInSecs = 0.0f;
        this.currentPositionInSecs = 0.0f;
        this.currentState = MediaPlaybackState.Uninitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(StateListener listener) {
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPositionListener(PositionListener listener) {
        List<PositionListener> list = this.positionListeners;
        synchronized (list) {
            this.positionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcyInfoListener(IcyInfoListener listener) {
        List<IcyInfoListener> list = this.icyInfoListeners;
        synchronized (list) {
            this.icyInfoListeners.add(listener);
        }
    }

    protected abstract void setStateListener(StateListener var1);

    protected abstract void setVolumeListener(VolumeListener var1);

    protected abstract void setMetaDataListener(MetaDataListener var1);

    protected abstract void setPositionListener(PositionListener var1);

    protected abstract void setIcyInfoListener(IcyInfoListener var1);

    protected abstract void doOpen(String var1, int var2);

    protected abstract void doPause();

    protected abstract void doResume();

    protected abstract void doStop();

    protected abstract void doSeek(float var1);

    protected abstract void doSetVolume(int var1);

    public abstract void doLoadSubtitlesFile(String var1, boolean var2);

    @Override
    public void open(String fileOrUrl, int initialVolume) {
        if (this.currentState == MediaPlaybackState.Uninitialized || this.currentState == MediaPlaybackState.Stopped) {
            this.openedFile = fileOrUrl;
            this.doOpen(fileOrUrl, initialVolume);
        } else {
            this.doStop();
            this.initialize();
            this.openedFile = fileOrUrl;
            this.doOpen(fileOrUrl, initialVolume);
        }
    }

    @Override
    public String getOpenedFile() {
        return this.openedFile;
    }

    public void fastForward() {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.seek((float)((double)this.currentPositionInSecs + 10.0));
        }
    }

    public void rewind() {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.seek((float)((double)this.currentPositionInSecs - 10.0));
        }
    }

    @Override
    public void pause() {
        if (this.currentState == MediaPlaybackState.Playing) {
            this.doPause();
        }
    }

    @Override
    public void play() {
        if (this.currentState == MediaPlaybackState.Paused) {
            this.doResume();
        }
    }

    @Override
    public void togglePause() {
        if (this.currentState == MediaPlaybackState.Paused) {
            this.doResume();
        } else if (this.currentState == MediaPlaybackState.Playing) {
            this.doPause();
        }
    }

    @Override
    public synchronized void seek(float timeInSecs) {
        if (timeInSecs < 0.0f) {
            timeInSecs = 0.0f;
        }
        if (timeInSecs > this.durationInSecs) {
            timeInSecs = this.durationInSecs;
        }
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.doSeek(timeInSecs);
        }
    }

    public void incrementVolume() {
        this.setVolume(this.getVolume() + 10);
    }

    public void decrementVolume() {
        this.setVolume(this.getVolume() - 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedDisplayResolution(int width, int height) {
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.receivedDisplayResolution(width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedDuration(float durationInSecs) {
        this.durationInSecs = durationInSecs;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.receivedDuration(durationInSecs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedVideoResolution(int width, int height) {
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.receivedVideoResolution(width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void foundAudioTrack(Language language) {
        List<MetaDataListener> list = this.audioTracksLock;
        synchronized (list) {
            this.audioTracks.add(language);
        }
        list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.foundAudioTrack(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void foundSubtitle(Language language) {
        List<MetaDataListener> list = this.subtitlesLock;
        synchronized (list) {
            this.subtitles.add(language);
        }
        list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.foundSubtitle(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeAudioTrackChanged(String audioTrackId) {
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.activeAudioTrackChanged(audioTrackId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeSubtitleChanged(String subtitleId, LanguageSource source2) {
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener listener : this.metaDataListeners) {
                listener.activeSubtitleChanged(subtitleId, source2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(MediaPlaybackState newState) {
        this.currentState = newState;
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            for (StateListener listener : this.stateListeners) {
                listener.stateChanged(newState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void volumeChanged(int newVolume) {
        this.currentVolume = newVolume;
        List<VolumeListener> list = this.volumeListeners;
        synchronized (list) {
            for (VolumeListener listener : this.volumeListeners) {
                listener.volumeChanged(newVolume);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void positionChanged(float currentTimeInSecs) {
        if (this.currentPositionInSecs != currentTimeInSecs) {
            this.currentPositionInSecs = currentTimeInSecs;
            List<PositionListener> list = this.positionListeners;
            synchronized (list) {
                for (PositionListener listener : this.positionListeners) {
                    listener.positionChanged(currentTimeInSecs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newIcyInfoData(String data) {
        List<IcyInfoListener> list = this.icyInfoListeners;
        synchronized (list) {
            for (IcyInfoListener listener : this.icyInfoListeners) {
                listener.newIcyInfoData(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskStarted(String taskName) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            for (TaskListener listener : this.taskListeners) {
                listener.taskStarted(taskName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskProgress(String taskName, int percent) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            for (TaskListener listener : this.taskListeners) {
                listener.taskProgress(taskName, percent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskEnded(String taskName) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            for (TaskListener listener : this.taskListeners) {
                listener.taskEnded(taskName);
            }
        }
    }

    @Override
    public void stop() {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.doStop();
        }
    }

    @Override
    public MediaPlaybackState getCurrentState() {
        return this.currentState;
    }

    @Override
    public int getVolume() {
        return this.currentVolume;
    }

    @Override
    public void setVolume(int volume) {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.doSetVolume(volume);
        }
    }

    @Override
    public float getPositionInSecs() {
        return this.currentPositionInSecs;
    }

    @Override
    public float getDurationInSecs() {
        return this.durationInSecs;
    }
}

