/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.ContainerBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import com.frostwire.mp4.SampleEntry;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class HintSampleEntry
extends SampleEntry {
    protected byte[] data;

    HintSampleEntry(int protocol) {
        super(protocol);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        int len = (int)(this.length() - 8L);
        if (len != 0) {
            IO.read(ch, len, buf);
            this.data = new byte[len];
            buf.get(this.data);
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        if (this.data != null) {
            buf.put(this.data);
            IO.write(ch, this.data.length, buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 8L;
        if (this.data != null) {
            s += (long)this.data.length;
        }
        this.length(s += ContainerBox.length(this.boxes));
    }
}

