/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jpeg;

import com.frostwire.jpeg.ImageInputStreamAdapter;
import com.frostwire.jpeg.JFIFInputStream;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class CMYKJPEGImageReader
extends ImageReader {
    private static final int SCALEBITS = 16;
    private static final int MAXJSAMPLE = 255;
    private static final int CENTERJSAMPLE = 128;
    private static final int ONE_HALF = 32768;
    private static final int[] Cr_r_tab = new int[256];
    private static final int[] Cb_b_tab = new int[256];
    private static final int[] Cr_g_tab = new int[256];
    private static final int[] Cb_g_tab = new int[256];
    private static final DirectColorModel RGB = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private BufferedImage image;

    private CMYKJPEGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public static BufferedImage read(ImageInputStream in, boolean inverseYCCKColors) throws IOException {
        in.seek(0L);
        boolean samplePrecision = false;
        boolean numberOfLines = false;
        boolean numberOfSamplesPerLine = false;
        int numberOfComponentsInFrame = 0;
        int app14AdobeColorTransform = 0;
        ByteArrayOutputStream app2ICCProfile = new ByteArrayOutputStream();
        JFIFInputStream fifi = new JFIFInputStream(new ImageInputStreamAdapter(in));
        JFIFInputStream.Segment seg = fifi.getNextSegment();
        while (seg != null) {
            DataInputStream dis;
            if (65472 <= seg.marker && seg.marker <= 65475 || 65477 <= seg.marker && seg.marker <= 65479 || 65481 <= seg.marker && seg.marker <= 65483 || 65485 <= seg.marker && seg.marker <= 65487) {
                dis = new DataInputStream(fifi);
                numberOfComponentsInFrame = dis.readUnsignedByte();
                break;
            }
            if (seg.marker == 65506) {
                if (seg.length >= 26 && (dis = new DataInputStream(fifi)).readLong() == 5279137264856878918L && dis.readInt() == 1229735168) {
                    dis.skipBytes(2);
                    byte[] b = new byte[512];
                    int count = dis.read(b);
                    while (count != -1) {
                        app2ICCProfile.write(b, 0, count);
                        count = dis.read(b);
                    }
                }
            } else if (seg.marker == 65518 && seg.length == 12 && (long)(dis = new DataInputStream(fifi)).readInt() == 1097101154L && dis.readUnsignedShort() == 25856) {
                int version = dis.readUnsignedByte();
                int app14Flags0 = dis.readUnsignedShort();
                int app14Flags1 = dis.readUnsignedShort();
                app14AdobeColorTransform = dis.readUnsignedByte();
            }
            seg = fifi.getNextSegment();
        }
        BufferedImage img = null;
        if (numberOfComponentsInFrame != 4) {
            in.seek(0L);
            img = CMYKJPEGImageReader.readImageFromYUVorGray(in);
        } else if (numberOfComponentsInFrame == 4) {
            ICC_Profile profile = null;
            if (app2ICCProfile.size() > 0) {
                try {
                    profile = ICC_Profile.getInstance(new ByteArrayInputStream(app2ICCProfile.toByteArray()));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            if (profile == null) {
                profile = ICC_Profile.getInstance(CMYKJPEGImageReader.class.getResourceAsStream("Generic CMYK Profile.icc"));
            }
            switch (app14AdobeColorTransform) {
                default: {
                    in.seek(0L);
                    img = CMYKJPEGImageReader.readRGBAImageFromRGBA(new ImageInputStreamAdapter(in));
                    break;
                }
                case 1: {
                    throw new IOException("YCbCr not supported");
                }
                case 2: {
                    in.seek(0L);
                    img = inverseYCCKColors ? CMYKJPEGImageReader.readRGBImageFromInvertedYCCK(new ImageInputStreamAdapter(in), profile) : CMYKJPEGImageReader.readRGBImageFromYCCK(new ImageInputStreamAdapter(in), profile);
                }
            }
        }
        return img;
    }

    private static ImageReader createNativeJPEGReader() {
        Iterator<ImageReader> i2 = ImageIO.getImageReadersByFormatName("jpeg");
        while (i2.hasNext()) {
            ImageReader r = i2.next();
            if (r instanceof CMYKJPEGImageReader) continue;
            return r;
        }
        return null;
    }

    private static BufferedImage readRGBAImageFromRGBA(InputStream in) throws IOException {
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        ImageInputStream inputStream2 = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
        reader.setInput(inputStream2);
        Raster raster = reader.readRaster(0, null);
        return CMYKJPEGImageReader.createRGBAImageFromRGBA(raster);
    }

    private static BufferedImage readRGBImageFromYCCK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        ImageInputStream inputStream2 = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
        reader.setInput(inputStream2);
        Raster raster = reader.readRaster(0, null);
        return CMYKJPEGImageReader.createRGBImageFromYCCK(raster, cmykProfile);
    }

    private static BufferedImage readRGBImageFromInvertedYCCK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        ImageInputStream inputStream2 = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
        reader.setInput(inputStream2);
        Raster raster = reader.readRaster(0, null);
        raster = CMYKJPEGImageReader.convertInvertedYCCKToCMYK(raster);
        return CMYKJPEGImageReader.createRGBImageFromCMYK(raster, cmykProfile);
    }

    private static BufferedImage createRGBImageFromYCCK(Raster ycckRaster, ICC_Profile cmykProfile) {
        BufferedImage image;
        if (cmykProfile != null) {
            ycckRaster = CMYKJPEGImageReader.convertYCCKtoCMYK(ycckRaster);
            image = CMYKJPEGImageReader.createRGBImageFromCMYK(ycckRaster, cmykProfile);
        } else {
            int w = ycckRaster.getWidth();
            int h = ycckRaster.getHeight();
            int[] rgb = new int[w * h];
            int[] Y = ycckRaster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] Cb = ycckRaster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] Cr = ycckRaster.getSamples(0, 0, w, h, 2, (int[])null);
            int[] K = ycckRaster.getSamples(0, 0, w, h, 3, (int[])null);
            int imax = Y.length;
            for (int i2 = 0; i2 < imax; ++i2) {
                float k = K[i2];
                float y = Y[i2];
                float cb = Cb[i2];
                float cr = Cr[i2];
                float vr = y + 1.402f * (cr - 128.0f) - k;
                float vg = y - 0.34414f * (cb - 128.0f) - 0.71414f * (cr - 128.0f) - k;
                float vb = y + 1.772f * (cb - 128.0f) - k;
                rgb[i2] = (0xFF & (vr < 0.0f ? 0 : (vr > 255.0f ? 255 : (int)(vr + 0.5f)))) << 16 | (0xFF & (vg < 0.0f ? 0 : (vg > 255.0f ? 255 : (int)(vg + 0.5f)))) << 8 | 0xFF & (vb < 0.0f ? 0 : (vb > 255.0f ? 255 : (int)(vb + 0.5f)));
            }
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            DirectColorModel cm = new DirectColorModel(cs, 24, 0xFF0000, 65280, 255, 0, false, 3);
            image = new BufferedImage(cm, rgbRaster, true, null);
        }
        return image;
    }

    public static BufferedImage createRGBImageFromInvertedYCCK(Raster ycckRaster, ICC_Profile cmykProfile) {
        BufferedImage image;
        if (cmykProfile != null) {
            ycckRaster = CMYKJPEGImageReader.convertInvertedYCCKToCMYK(ycckRaster);
            image = CMYKJPEGImageReader.createRGBImageFromCMYK(ycckRaster, cmykProfile);
        } else {
            int w = ycckRaster.getWidth();
            int h = ycckRaster.getHeight();
            int[] rgb = new int[w * h];
            int[] Y = ycckRaster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] Cb = ycckRaster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] Cr = ycckRaster.getSamples(0, 0, w, h, 2, (int[])null);
            int[] K = ycckRaster.getSamples(0, 0, w, h, 3, (int[])null);
            int imax = Y.length;
            for (int i2 = 0; i2 < imax; ++i2) {
                float k = 255 - K[i2];
                float y = 255 - Y[i2];
                float cb = 255 - Cb[i2];
                float cr = 255 - Cr[i2];
                float vr = y + 1.402f * (cr - 128.0f) - k;
                float vg = y - 0.34414f * (cb - 128.0f) - 0.71414f * (cr - 128.0f) - k;
                float vb = y + 1.772f * (cb - 128.0f) - k;
                rgb[i2] = (0xFF & (vr < 0.0f ? 0 : (vr > 255.0f ? 255 : (int)(vr + 0.5f)))) << 16 | (0xFF & (vg < 0.0f ? 0 : (vg > 255.0f ? 255 : (int)(vg + 0.5f)))) << 8 | 0xFF & (vb < 0.0f ? 0 : (vb > 255.0f ? 255 : (int)(vb + 0.5f)));
            }
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            DirectColorModel cm = new DirectColorModel(cs, 24, 0xFF0000, 65280, 255, 0, false, 3);
            image = new BufferedImage(cm, rgbRaster, true, null);
        }
        return image;
    }

    private static BufferedImage createRGBImageFromCMYK(Raster cmykRaster, ICC_Profile cmykProfile) {
        BufferedImage image;
        int w = cmykRaster.getWidth();
        int h = cmykRaster.getHeight();
        if (cmykProfile != null) {
            ICC_ColorSpace cmykCS = new ICC_ColorSpace(cmykProfile);
            image = new BufferedImage(w, h, 1);
            WritableRaster rgbRaster = image.getRaster();
            ColorSpace rgbCS = image.getColorModel().getColorSpace();
            ColorConvertOp cmykToRgb = new ColorConvertOp(cmykCS, rgbCS, null);
            cmykToRgb.filter(cmykRaster, rgbRaster);
        } else {
            int[] rgb = new int[w * h];
            int[] C = cmykRaster.getSamples(0, 0, w, h, 0, (int[])null);
            int[] M = cmykRaster.getSamples(0, 0, w, h, 1, (int[])null);
            int[] Y = cmykRaster.getSamples(0, 0, w, h, 2, (int[])null);
            int[] K = cmykRaster.getSamples(0, 0, w, h, 3, (int[])null);
            int imax = C.length;
            for (int i2 = 0; i2 < imax; ++i2) {
                int k = K[i2];
                rgb[i2] = 255 - Math.min(255, C[i2] + k) << 16 | 255 - Math.min(255, M[i2] + k) << 8 | 255 - Math.min(255, Y[i2] + k);
            }
            WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255}, null);
            ColorSpace cs = ColorSpace.getInstance(1000);
            DirectColorModel cm = new DirectColorModel(cs, 24, 0xFF0000, 65280, 255, 0, false, 3);
            image = new BufferedImage(cm, rgbRaster, true, null);
        }
        return image;
    }

    private static BufferedImage createRGBAImageFromRGBA(Raster rgbaRaster) {
        int w = rgbaRaster.getWidth();
        int h = rgbaRaster.getHeight();
        int[] rgb = new int[w * h];
        int[] R = rgbaRaster.getSamples(0, 0, w, h, 0, (int[])null);
        int[] G = rgbaRaster.getSamples(0, 0, w, h, 1, (int[])null);
        int[] B = rgbaRaster.getSamples(0, 0, w, h, 2, (int[])null);
        int[] A = rgbaRaster.getSamples(0, 0, w, h, 3, (int[])null);
        int imax = R.length;
        for (int i2 = 0; i2 < imax; ++i2) {
            rgb[i2] = A[i2] << 24 | R[i2] << 16 | G[i2] << 8 | B[i2];
        }
        WritableRaster rgbRaster = Raster.createPackedRaster(new DataBufferInt(rgb, rgb.length), w, h, w, new int[]{0xFF0000, 65280, 255, -16777216}, null);
        ColorSpace cs = ColorSpace.getInstance(1000);
        DirectColorModel cm = new DirectColorModel(cs, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
        BufferedImage image = new BufferedImage(cm, rgbRaster, true, null);
        return image;
    }

    private static synchronized void buildYCCtoRGBtable() {
        if (Cr_r_tab[0] == 0) {
            int i2 = 0;
            int x = -128;
            while (i2 <= 255) {
                CMYKJPEGImageReader.Cr_r_tab[i2] = (int)(91881.972 * (double)x + 32768.0) >> 16;
                CMYKJPEGImageReader.Cb_b_tab[i2] = (int)(116130.292 * (double)x + 32768.0) >> 16;
                CMYKJPEGImageReader.Cr_g_tab[i2] = -46802 * x;
                CMYKJPEGImageReader.Cb_g_tab[i2] = -22554 * x + 32768;
                ++i2;
                ++x;
            }
        }
    }

    private static Raster convertInvertedYCCKToCMYK(Raster ycckRaster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        int[] ycckY = ycckRaster.getSamples(0, 0, w, h, 0, (int[])null);
        int[] ycckCb = ycckRaster.getSamples(0, 0, w, h, 1, (int[])null);
        int[] ycckCr = ycckRaster.getSamples(0, 0, w, h, 2, (int[])null);
        int[] ycckK = ycckRaster.getSamples(0, 0, w, h, 3, (int[])null);
        int[] cmyk = new int[ycckY.length];
        for (int i2 = 0; i2 < ycckY.length; ++i2) {
            int y = 255 - ycckY[i2];
            int cb = 255 - ycckCb[i2];
            int cr = 255 - ycckCr[i2];
            int cmykC = 255 - (y + Cr_r_tab[cr]);
            int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
            int cmykY = 255 - (y + Cb_b_tab[cb]);
            cmyk[i2] = (cmykC < 0 ? 0 : Math.min(cmykC, 255)) << 24 | (cmykM < 0 ? 0 : Math.min(cmykM, 255)) << 16 | (cmykY < 0 ? 0 : Math.min(cmykY, 255)) << 8 | 255 - ycckK[i2];
        }
        return Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
    }

    private static Raster convertYCCKtoCMYK(Raster ycckRaster) {
        CMYKJPEGImageReader.buildYCCtoRGBtable();
        int w = ycckRaster.getWidth();
        int h = ycckRaster.getHeight();
        int[] ycckY = ycckRaster.getSamples(0, 0, w, h, 0, (int[])null);
        int[] ycckCb = ycckRaster.getSamples(0, 0, w, h, 1, (int[])null);
        int[] ycckCr = ycckRaster.getSamples(0, 0, w, h, 2, (int[])null);
        int[] ycckK = ycckRaster.getSamples(0, 0, w, h, 3, (int[])null);
        int[] cmyk = new int[ycckY.length];
        for (int i2 = 0; i2 < ycckY.length; ++i2) {
            int y = ycckY[i2];
            int cb = ycckCb[i2];
            int cr = ycckCr[i2];
            int cmykC = 255 - (y + Cr_r_tab[cr]);
            int cmykM = 255 - (y + (Cb_g_tab[cb] + Cr_g_tab[cr] >> 16));
            int cmykY = 255 - (y + Cb_b_tab[cb]);
            cmyk[i2] = (cmykC < 0 ? 0 : Math.min(cmykC, 255)) << 24 | (cmykM < 0 ? 0 : Math.min(cmykM, 255)) << 16 | (cmykY < 0 ? 0 : Math.min(cmykY, 255)) << 8 | ycckK[i2];
        }
        return Raster.createPackedRaster(new DataBufferInt(cmyk, cmyk.length), w, h, w, new int[]{-16777216, 0xFF0000, 65280, 255}, null);
    }

    private static BufferedImage readImageFromYUVorGray(ImageInputStream in) throws IOException {
        ImageReader r = CMYKJPEGImageReader.createNativeJPEGReader();
        r.setInput(in);
        return r.read(0);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readHeader();
        LinkedList<ImageTypeSpecifier> l = new LinkedList<ImageTypeSpecifier>();
        l.add(new ImageTypeSpecifier(RGB, RGB.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight())));
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (imageIndex > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.readHeader();
        return this.image;
    }

    private void readHeader() throws IOException {
        if (this.image == null) {
            ImageInputStream iis;
            Object in = this.getInput();
            if (in instanceof byte[]) {
                iis = ImageIO.createImageInputStream(in);
            } else if (in instanceof ImageInputStream) {
                iis = (ImageInputStream)in;
            } else if (in instanceof InputStream) {
                iis = new MemoryCacheImageInputStream((InputStream)in);
            } else {
                throw new IOException("Can't handle input of type " + String.valueOf(in));
            }
            boolean isYCCKInversed = true;
            this.image = CMYKJPEGImageReader.read(iis, isYCCKInversed);
        }
    }
}

