/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.AnnounceEntry;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.FileSlice;
import com.frostwire.jlibtorrent.FileStorage;
import com.frostwire.jlibtorrent.Files;
import com.frostwire.jlibtorrent.Pair;
import com.frostwire.jlibtorrent.PeerRequest;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.WebSeedEntry;
import com.frostwire.jlibtorrent.swig.announce_entry_vector;
import com.frostwire.jlibtorrent.swig.bdecode_node;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.create_torrent;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.libtorrent_jni;
import com.frostwire.jlibtorrent.swig.sha1_hash_vector;
import com.frostwire.jlibtorrent.swig.string_int_pair;
import com.frostwire.jlibtorrent.swig.string_int_pair_vector;
import com.frostwire.jlibtorrent.swig.string_string_pair_vector;
import com.frostwire.jlibtorrent.swig.string_vector;
import com.frostwire.jlibtorrent.swig.torrent_info;
import com.frostwire.jlibtorrent.swig.web_seed_entry_vector;
import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class TorrentInfo {
    private final torrent_info ti;

    public TorrentInfo(torrent_info ti) {
        this.ti = ti;
    }

    public TorrentInfo(File torrent) {
        this(TorrentInfo.bdecode0(torrent));
    }

    public TorrentInfo(byte[] data) {
        this(TorrentInfo.bdecode0(data));
    }

    public TorrentInfo(MappedByteBuffer buffer) {
        try {
            long ptr = libtorrent_jni.directBufferAddress(buffer);
            long size = libtorrent_jni.directBufferCapacity(buffer);
            error_code ec = new error_code();
            this.ti = new torrent_info(ptr, (int)size, ec);
            if (ec.value() != 0) {
                throw new IllegalArgumentException("Can't decode data: " + ec.message());
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Can't decode data mapped buffer: " + e.getMessage(), e);
        }
    }

    public torrent_info swig() {
        return this.ti;
    }

    public FileStorage files() {
        return new FileStorage(this.ti.files(), this.ti);
    }

    public FileStorage origFiles() {
        return new FileStorage(this.ti.orig_files(), this.ti);
    }

    public void renameFile(int index, String newFilename) {
        this.ti.rename_file(index, newFilename);
    }

    public void remapFiles(FileStorage f) {
        this.ti.remap_files(f.swig());
    }

    public void addTracker(String url) {
        this.ti.add_tracker(url);
    }

    public void addTracker(String url, int tier) {
        this.ti.add_tracker(url, tier);
    }

    public ArrayList<AnnounceEntry> trackers() {
        return TorrentInfo.trackers(this.ti.trackers());
    }

    public ArrayList<Sha1Hash> similarTorrents() {
        return Sha1Hash.convert(this.ti.similar_torrents());
    }

    public ArrayList<String> collections() {
        string_vector v = this.ti.collections();
        int size = (int)v.size();
        ArrayList<String> l = new ArrayList<String>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(v.get(i2));
        }
        return l;
    }

    public void clearTrackers() {
        this.ti.trackers().clear();
    }

    public void addUrlSeed(String url) {
        this.ti.add_url_seed(url);
    }

    public void addUrlSeed(String url, String externAuth) {
        this.ti.add_url_seed(url, externAuth);
    }

    public void addUrlSeed(String url, String externAuth, List<Pair<String, String>> extraHeaders) {
        string_string_pair_vector v = new string_string_pair_vector();
        for (Pair<String, String> p : extraHeaders) {
            v.push_back(p.to_string_string_pair());
        }
        this.ti.add_url_seed(url, externAuth, v);
    }

    public void addHttpSeed(String url) {
        this.ti.add_url_seed(url);
    }

    public void addHttpSeed(String url, String externAuth) {
        this.ti.add_url_seed(url, externAuth);
    }

    public void addHttpSeed(String url, String externAuth, List<Pair<String, String>> extraHeaders) {
        string_string_pair_vector v = new string_string_pair_vector();
        for (Pair<String, String> p : extraHeaders) {
            v.push_back(p.to_string_string_pair());
        }
        this.ti.add_url_seed(url, externAuth, v);
    }

    public ArrayList<WebSeedEntry> webSeeds() {
        web_seed_entry_vector v = this.ti.web_seeds();
        int size = (int)v.size();
        ArrayList<WebSeedEntry> l = new ArrayList<WebSeedEntry>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(new WebSeedEntry(v.get(i2)));
        }
        return l;
    }

    public void setWebSeeds(List<WebSeedEntry> seeds) {
        web_seed_entry_vector v = new web_seed_entry_vector();
        for (WebSeedEntry e : seeds) {
            v.push_back(e.swig());
        }
        this.ti.set_web_seeds(v);
    }

    public long totalSize() {
        return this.ti.total_size();
    }

    public int pieceLength() {
        return this.ti.piece_length();
    }

    public int numPieces() {
        return this.ti.num_pieces();
    }

    public Sha1Hash infoHash() {
        return new Sha1Hash(this.ti.info_hash());
    }

    public int numFiles() {
        return this.ti.num_files();
    }

    public ArrayList<FileSlice> mapBlock(int piece, long offset, int size) {
        return FileStorage.mapBlock(this.ti.map_block(piece, offset, size));
    }

    public PeerRequest mapFile(int file, long offset, int size) {
        return new PeerRequest(this.ti.map_file(file, offset, size));
    }

    byte[] sslCert() {
        byte_vector v = this.ti.ssl_cert().to_bytes();
        return Vectors.byte_vector2bytes(v);
    }

    public boolean isValid() {
        return this.ti.is_valid();
    }

    public boolean isPrivate() {
        return this.ti.priv();
    }

    public boolean isI2p() {
        return this.ti.is_i2p();
    }

    public int pieceSize(int index) {
        return this.ti.piece_size(index);
    }

    public Sha1Hash hashForPiece(int index) {
        return new Sha1Hash(this.ti.hash_for_piece(index));
    }

    public boolean isLoaded() {
        return this.ti.is_loaded();
    }

    public ArrayList<Sha1Hash> merkleTree() {
        return Sha1Hash.convert(this.ti.merkle_tree());
    }

    public void merkleTree(List<Sha1Hash> tree) {
        sha1_hash_vector v = new sha1_hash_vector();
        for (Sha1Hash h : tree) {
            v.push_back(h.swig());
        }
        this.ti.set_merkle_tree(v);
    }

    public String name() {
        return this.ti.name();
    }

    public long creationDate() {
        return this.ti.creation_date();
    }

    public String creator() {
        return this.ti.creator();
    }

    public String comment() {
        return this.ti.comment();
    }

    public ArrayList<Pair<String, Integer>> nodes() {
        string_int_pair_vector v = this.ti.nodes();
        int size = (int)v.size();
        ArrayList<Pair<String, Integer>> l = new ArrayList<Pair<String, Integer>>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            string_int_pair p = v.get(i2);
            l.add(new Pair<String, Integer>(p.getFirst(), p.getSecond()));
        }
        return l;
    }

    public void addNode(String host, int port) {
        this.ti.add_node(new string_int_pair(host, port));
    }

    public bdecode_node info(String key) {
        return this.ti.info(key);
    }

    public boolean isMerkleTorrent() {
        return this.ti.is_merkle_torrent();
    }

    public String makeMagnetUri() {
        return this.ti.is_valid() ? libtorrent.make_magnet_uri(this.ti) : null;
    }

    public Entry toEntry() {
        return new Entry(new create_torrent(this.ti).generate());
    }

    public byte[] bencode() {
        return this.toEntry().bencode();
    }

    public static TorrentInfo bdecode(byte[] data) {
        return new TorrentInfo(TorrentInfo.bdecode0(data));
    }

    static ArrayList<AnnounceEntry> trackers(announce_entry_vector v) {
        int size = (int)v.size();
        ArrayList<AnnounceEntry> l = new ArrayList<AnnounceEntry>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(new AnnounceEntry(v.get(i2)));
        }
        return l;
    }

    private static torrent_info bdecode0(File file) {
        try {
            byte[] data = Files.bytes(file);
            return TorrentInfo.bdecode0(data);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't decode data from file: " + file, e);
        }
    }

    private static torrent_info bdecode0(byte[] data) {
        error_code ec;
        bdecode_node n;
        byte_vector buffer = Vectors.bytes2byte_vector(data);
        int ret = bdecode_node.bdecode(buffer, n = new bdecode_node(), ec = new error_code());
        if (ret == 0) {
            ec.clear();
            torrent_info ti = new torrent_info(n, ec);
            buffer.clear();
            if (ec.value() != 0) {
                throw new IllegalArgumentException("Can't decode data: " + ec.message());
            }
            return ti;
        }
        throw new IllegalArgumentException("Can't decode data: " + ec.message());
    }
}

