/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Hex;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.sha1_hash;
import com.frostwire.jlibtorrent.swig.sha1_hash_vector;
import java.util.ArrayList;

public final class Sha1Hash
implements Comparable<Sha1Hash>,
Cloneable {
    private final sha1_hash h;

    public Sha1Hash(sha1_hash h) {
        this.h = h;
    }

    public Sha1Hash(byte[] bytes) {
        if (bytes.length != 20) {
            throw new IllegalArgumentException("bytes array must be of length 20");
        }
        this.h = new sha1_hash(Vectors.bytes2byte_vector(bytes));
    }

    public Sha1Hash(String hex) {
        this(Hex.decode(hex));
    }

    public Sha1Hash() {
        this(new sha1_hash());
    }

    public sha1_hash swig() {
        return this.h;
    }

    public void clear() {
        this.h.clear();
    }

    public boolean isAllZeros() {
        return this.h.is_all_zeros();
    }

    public int countLeadingZeroes() {
        return this.h.count_leading_zeroes();
    }

    public String toHex() {
        return this.h.to_hex();
    }

    @Override
    public int compareTo(Sha1Hash o) {
        return sha1_hash.compare(this.h, o.h);
    }

    public String toString() {
        return this.toHex();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Sha1Hash)) {
            return false;
        }
        return this.h.op_eq(((Sha1Hash)obj).h);
    }

    public int hashCode() {
        return this.h.hash_code();
    }

    public Sha1Hash clone() {
        return new Sha1Hash(new sha1_hash(this.h));
    }

    public static Sha1Hash max() {
        return new Sha1Hash(sha1_hash.max());
    }

    public static Sha1Hash min() {
        return new Sha1Hash(sha1_hash.min());
    }

    static ArrayList<Sha1Hash> convert(sha1_hash_vector v) {
        int size = (int)v.size();
        ArrayList<Sha1Hash> l = new ArrayList<Sha1Hash>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(new Sha1Hash(v.get(i2)));
        }
        return l;
    }
}

