/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.AddTorrentParams;
import com.frostwire.jlibtorrent.DhtSettings;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.ErrorCode;
import com.frostwire.jlibtorrent.Logger;
import com.frostwire.jlibtorrent.Pair;
import com.frostwire.jlibtorrent.Plugin;
import com.frostwire.jlibtorrent.PortmapProtocol;
import com.frostwire.jlibtorrent.SettingsPack;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.SwigPlugin;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.UdpEndpoint;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.swig.bdecode_node;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.port_mapping_t_vector;
import com.frostwire.jlibtorrent.swig.portmap_protocol;
import com.frostwire.jlibtorrent.swig.remove_flags_t;
import com.frostwire.jlibtorrent.swig.reopen_network_flags_t;
import com.frostwire.jlibtorrent.swig.save_state_flags_t;
import com.frostwire.jlibtorrent.swig.session_flags_t;
import com.frostwire.jlibtorrent.swig.session_handle;
import com.frostwire.jlibtorrent.swig.status_flags_t;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import com.frostwire.jlibtorrent.swig.torrent_handle_vector;
import java.util.ArrayList;
import java.util.List;

public class SessionHandle {
    private static final Logger LOG = Logger.getLogger(SessionHandle.class);
    protected final session_handle s;
    public static final session_flags_t PAUSED = session_handle.paused;
    public static final save_state_flags_t SAVE_SETTINGS = session_handle.save_settings;
    public static final save_state_flags_t SAVE_DHT_SETTINGS = session_handle.save_dht_settings;
    public static final save_state_flags_t SAVE_DHT_STATE = session_handle.save_dht_state;
    public static final remove_flags_t DELETE_FILES = session_handle.delete_files;
    public static final remove_flags_t DELETE_PARTFILE = session_handle.delete_partfile;
    public static final reopen_network_flags_t REOPEN_MAP_PORTS = session_handle.reopen_map_ports;
    public static final int DHT_ANNOUNCE_SEED = 1;
    public static final int DHT_ANNOUNCE_IMPLIED_PORT = 2;
    public static final int DHT_ANNOUNCE_SSL_TORRENT = 4;

    public SessionHandle(session_handle s) {
        this.s = s;
    }

    public session_handle swig() {
        return this.s;
    }

    public boolean isValid() {
        return this.s.is_valid();
    }

    public byte[] saveState(save_state_flags_t flags) {
        entry e = new entry();
        this.s.save_state(e, flags);
        return Vectors.byte_vector2bytes(e.bencode());
    }

    public byte[] saveState() {
        entry e = new entry();
        this.s.save_state(e);
        return Vectors.byte_vector2bytes(e.bencode());
    }

    public void loadState(byte[] data, save_state_flags_t flags) {
        error_code ec;
        bdecode_node n;
        byte_vector buffer = Vectors.bytes2byte_vector(data);
        int ret = bdecode_node.bdecode(buffer, n = new bdecode_node(), ec = new error_code());
        if (ret == 0) {
            this.s.load_state(n, flags);
            buffer.clear();
        } else {
            LOG.error("failed to decode bencoded data: " + ec.message());
        }
    }

    public void loadState(byte[] data) {
        error_code ec;
        bdecode_node n;
        byte_vector buffer = Vectors.bytes2byte_vector(data);
        int ret = bdecode_node.bdecode(buffer, n = new bdecode_node(), ec = new error_code());
        if (ret == 0) {
            this.s.load_state(n);
            buffer.clear();
        } else {
            LOG.error("failed to decode bencoded data: " + ec.message());
        }
    }

    public void postTorrentUpdates(status_flags_t flags) {
        this.s.post_torrent_updates(flags);
    }

    public void postTorrentUpdates() {
        this.s.post_torrent_updates();
    }

    public void postSessionStats() {
        this.s.post_session_stats();
    }

    public void postDhtStats() {
        this.s.post_dht_stats();
    }

    public TorrentHandle findTorrent(Sha1Hash infoHash) {
        torrent_handle th = this.s.find_torrent(infoHash.swig());
        return th != null && th.is_valid() ? new TorrentHandle(th) : null;
    }

    public List<TorrentHandle> torrents() {
        torrent_handle_vector v = this.s.get_torrents();
        int size = (int)v.size();
        ArrayList<TorrentHandle> l = new ArrayList<TorrentHandle>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(new TorrentHandle(v.get(i2)));
        }
        return l;
    }

    public TorrentHandle addTorrent(AddTorrentParams params, ErrorCode ec) {
        error_code e = new error_code();
        TorrentHandle th = new TorrentHandle(this.s.add_torrent(params.swig(), e));
        ec.assign(e);
        return th;
    }

    public void asyncAddTorrent(AddTorrentParams params) {
        this.s.async_add_torrent(params.swig());
    }

    public void removeTorrent(TorrentHandle th, remove_flags_t options) {
        if (th.isValid()) {
            this.s.remove_torrent(th.swig(), options);
        }
    }

    public void removeTorrent(TorrentHandle th) {
        if (th.isValid()) {
            this.s.remove_torrent(th.swig());
        }
    }

    public void pause() {
        this.s.pause();
    }

    public void resume() {
        this.s.resume();
    }

    public boolean isPaused() {
        return this.s.is_paused();
    }

    void setDhtSettings(DhtSettings settings2) {
        this.s.set_dht_settings(settings2.swig());
    }

    public boolean isDhtRunning() {
        return this.s.is_dht_running();
    }

    public void addDhtNode(Pair<String, Integer> node) {
        this.s.add_dht_node(node.to_string_int_pair());
    }

    public void applySettings(SettingsPack sp) {
        this.s.apply_settings(sp.swig());
    }

    public SettingsPack settings() {
        return new SettingsPack(this.s.get_settings());
    }

    public int[] addPortMapping(PortmapProtocol t, int externalPort, int localPort) {
        port_mapping_t_vector v = this.s.add_port_mapping(portmap_protocol.swigToEnum(t.swig()), externalPort, localPort);
        int size = (int)v.size();
        int[] arr = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            arr[i2] = v.get(i2);
        }
        return arr;
    }

    public void deletePortMapping(int handle) {
        this.s.delete_port_mapping(handle);
    }

    public void reopenNetworkSockets(reopen_network_flags_t options) {
        this.s.reopen_network_sockets(options);
    }

    public void reopenNetworkSockets() {
        this.s.reopen_network_sockets();
    }

    public void dhtGetItem(Sha1Hash target) {
        this.s.dht_get_item(target.swig());
    }

    public void dhtGetItem(byte[] key, byte[] salt) {
        this.s.dht_get_item(Vectors.bytes2byte_vector(key), Vectors.bytes2byte_vector(salt));
    }

    public Sha1Hash dhtPutItem(Entry entry2) {
        return new Sha1Hash(this.s.dht_put_item(entry2.swig()));
    }

    public void dhtPutItem(byte[] publicKey, byte[] privateKey, Entry entry2, byte[] salt) {
        this.s.dht_put_item(Vectors.bytes2byte_vector(publicKey), Vectors.bytes2byte_vector(privateKey), entry2.swig(), Vectors.bytes2byte_vector(salt));
    }

    public void dhtGetPeers(Sha1Hash infoHash) {
        this.s.dht_get_peers(infoHash.swig());
    }

    public void dhtAnnounce(Sha1Hash infoHash, int port, int flags) {
        this.s.dht_announce(infoHash.swig(), port, flags);
    }

    public void dhtAnnounce(Sha1Hash infoHash) {
        this.s.dht_announce(infoHash.swig());
    }

    public void dhtDirectRequest(UdpEndpoint endp, Entry entry2, long userdata) {
        this.s.dht_direct_request(endp.swig(), entry2.swig(), userdata);
    }

    public void dhtDirectRequest(UdpEndpoint endp, Entry entry2) {
        this.s.dht_direct_request(endp.swig(), entry2.swig());
    }

    public int getListenPort() {
        return this.s.listen_port();
    }

    public int getSslListenPort() {
        return this.s.ssl_listen_port();
    }

    public boolean isListening() {
        return this.s.is_listening();
    }

    public void addExtension(Plugin plugin) {
        SwigPlugin p = new SwigPlugin(plugin);
        this.s.add_extension(p);
        p.swigReleaseOwnership();
    }
}

