/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.FileSlice;
import com.frostwire.jlibtorrent.FileStorage;
import com.frostwire.jlibtorrent.TorrentInfo;
import java.util.ArrayList;

public final class PiecesTracker {
    private final int numFiles;
    private final int numPieces;
    private final int[][] files;
    private final long[][] sizes;
    private final boolean[] complete;

    public PiecesTracker(TorrentInfo ti) {
        this.numFiles = ti.numFiles();
        this.numPieces = ti.numPieces();
        this.files = new int[this.numFiles][];
        this.sizes = new long[this.numFiles][];
        this.complete = new boolean[this.numPieces];
        FileStorage fs = ti.files();
        for (int fileIndex = 0; fileIndex < this.numFiles; ++fileIndex) {
            long size = fs.fileSize(fileIndex);
            int firstPiece = ti.mapFile(fileIndex, 0L, 1).piece();
            int lastPiece = ti.mapFile(fileIndex, size - 1L, 1).piece();
            int numSlices = lastPiece - firstPiece + 1;
            this.files[fileIndex] = new int[numSlices];
            this.sizes[fileIndex] = new long[numSlices];
            for (int pieceIndex = firstPiece; pieceIndex <= lastPiece; ++pieceIndex) {
                int index = pieceIndex - firstPiece;
                this.files[fileIndex][index] = pieceIndex;
                ArrayList<FileSlice> slices = ti.mapBlock(pieceIndex, 0L, ti.pieceSize(pieceIndex));
                for (FileSlice slice : slices) {
                    if (slice.fileIndex() != fileIndex) continue;
                    this.sizes[fileIndex][index] = slice.size();
                }
            }
        }
    }

    public int numFiles() {
        return this.numFiles;
    }

    public int numPieces() {
        return this.numPieces;
    }

    public boolean isComplete(int pieceIndex) {
        return this.complete[pieceIndex];
    }

    public void setComplete(int pieceIndex, boolean complete) {
        this.complete[pieceIndex] = complete;
    }

    public long getSequentialDownloadedBytes(int fileIndex) {
        int pieceIndex;
        int[] pieces = this.files[fileIndex];
        long downloaded = 0L;
        for (int i2 = 0; i2 < pieces.length && this.complete[pieceIndex = pieces[i2]]; ++i2) {
            downloaded += this.sizes[fileIndex][i2];
        }
        return downloaded;
    }

    public int getSequentialDownloadedPieces(int fileIndex) {
        int pieceIndex;
        int[] pieces = this.files[fileIndex];
        int count = 0;
        for (int i2 = 0; i2 < pieces.length && this.complete[pieceIndex = pieces[i2]]; ++i2) {
            ++count;
        }
        return count;
    }
}

