/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

public final class IntSeries {
    private final long[] buffer;
    private int head;
    private int end;
    private int size;

    IntSeries(long[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer to hold data can't be null");
        }
        if (buffer.length == 0) {
            throw new IllegalArgumentException("buffer to hold data can't be of size 0");
        }
        this.buffer = buffer;
        this.head = -1;
        this.end = -1;
        this.size = 0;
    }

    IntSeries(int capacity) {
        this(new long[capacity]);
    }

    void add(long value) {
        if (this.head == -1) {
            this.end = 0;
            this.head = 0;
            this.buffer[this.end] = value;
            this.size = 1;
            return;
        }
        this.end = (this.end + 1) % this.buffer.length;
        this.buffer[this.end] = value;
        if (this.end <= this.head) {
            this.head = (this.head + 1) % this.buffer.length;
        }
        this.size = this.head <= this.end ? 1 + (this.end - this.head) : this.buffer.length;
    }

    public long get(int index) {
        return this.buffer[(this.head + index) % this.size];
    }

    public long last() {
        return this.end != 0 ? this.buffer[this.end] : 0L;
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (int i2 = 0; i2 < this.buffer.length; ++i2) {
            sb.append(this.buffer[i2]);
            if (i2 == this.buffer.length - 1) continue;
            sb.append(", ");
        }
        sb.append(" ]");
        return "{ head: " + this.head + ", end: " + this.end + ", size: " + this.size() + ", buffer: " + sb.toString() + " }";
    }
}

