/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Pair;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.StorageMode;
import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.swig.add_torrent_params;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.int_vector;
import com.frostwire.jlibtorrent.swig.storage_mode_t;
import com.frostwire.jlibtorrent.swig.string_int_pair;
import com.frostwire.jlibtorrent.swig.string_int_pair_vector;
import com.frostwire.jlibtorrent.swig.string_vector;
import com.frostwire.jlibtorrent.swig.tcp_endpoint_vector;
import com.frostwire.jlibtorrent.swig.torrent_flags_t;
import com.frostwire.jlibtorrent.swig.torrent_info;
import java.util.ArrayList;
import java.util.List;

public final class AddTorrentParams {
    private final add_torrent_params p;

    public AddTorrentParams(add_torrent_params p) {
        this.p = p;
    }

    public AddTorrentParams() {
        this(add_torrent_params.create_instance());
    }

    public add_torrent_params swig() {
        return this.p;
    }

    public int version() {
        return this.p.getVersion();
    }

    public TorrentInfo torrentInfo() {
        torrent_info ti = this.p.ti_ptr();
        return ti != null && ti.is_valid() ? new TorrentInfo(ti) : null;
    }

    public void torrentInfo(TorrentInfo ti) {
        this.p.set_ti(ti.swig());
    }

    public ArrayList<String> trackers() {
        string_vector v = this.p.get_trackers();
        int size = (int)v.size();
        ArrayList<String> l = new ArrayList<String>();
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(v.get(i2));
        }
        return l;
    }

    public void trackers(List<String> value) {
        string_vector v = new string_vector();
        for (String s : value) {
            v.push_back(s);
        }
        this.p.set_trackers(v);
    }

    public ArrayList<Integer> trackerTiers() {
        int_vector v = this.p.get_tracker_tiers();
        int size = (int)v.size();
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(v.get(i2));
        }
        return l;
    }

    public void trackerTiers(List<Integer> value) {
        int_vector v = new int_vector();
        for (Integer t : value) {
            v.push_back(t);
        }
        this.p.set_tracker_tiers(v);
    }

    public ArrayList<Pair<String, Integer>> dhtNodes() {
        string_int_pair_vector v = this.p.get_dht_nodes();
        int size = (int)v.size();
        ArrayList<Pair<String, Integer>> l = new ArrayList<Pair<String, Integer>>();
        for (int i2 = 0; i2 < size; ++i2) {
            string_int_pair n = v.get(i2);
            l.add(new Pair<String, Integer>(n.getFirst(), n.getSecond()));
        }
        return l;
    }

    public void dhtNodes(List<Pair<String, Integer>> value) {
        string_int_pair_vector v = new string_int_pair_vector();
        for (Pair<String, Integer> p : value) {
            v.push_back(p.to_string_int_pair());
        }
        this.p.set_dht_nodes(v);
    }

    public String name() {
        return this.p.getName();
    }

    public void name(String value) {
        this.p.setName(value);
    }

    public String savePath() {
        return this.p.getSave_path();
    }

    public void savePath(String value) {
        this.p.setSave_path(value);
    }

    public StorageMode storageMode() {
        return StorageMode.fromSwig(this.p.getStorage_mode().swigValue());
    }

    public void storageMode(StorageMode value) {
        this.p.setStorage_mode(storage_mode_t.swigToEnum(value.swig()));
    }

    public String trackerId() {
        return this.p.getTrackerid();
    }

    public void trackerId(String value) {
        this.p.setTrackerid(value);
    }

    public Sha1Hash infoHash() {
        return new Sha1Hash(this.p.getInfo_hash());
    }

    public void infoHash(Sha1Hash value) {
        this.p.setInfo_hash(value.swig());
    }

    public int maxUploads() {
        return this.p.getMax_uploads();
    }

    public void maxUploads(int value) {
        this.p.setMax_uploads(value);
    }

    public int maxConnections() {
        return this.p.getMax_connections();
    }

    public void maxConnections(int value) {
        this.p.setMax_connections(value);
    }

    public int uploadLimit() {
        return this.p.getUpload_limit();
    }

    public void uploadLimit(int value) {
        this.p.setUpload_limit(value);
    }

    public int downloadLimit() {
        return this.p.getDownload_limit();
    }

    public void downloadLimit(int value) {
        this.p.setDownload_limit(value);
    }

    public torrent_flags_t flags() {
        return this.p.getFlags();
    }

    public void flags(torrent_flags_t flags) {
        this.p.setFlags(flags);
    }

    public ArrayList<String> urlSeeds() {
        string_vector v = this.p.get_url_seeds();
        int size = (int)v.size();
        ArrayList<String> l = new ArrayList<String>();
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(v.get(i2));
        }
        return l;
    }

    public void urlSeeds(List<String> value) {
        string_vector v = new string_vector();
        for (String s : value) {
            v.push_back(s);
        }
        this.p.set_url_seeds(v);
    }

    public void filePriorities(Priority[] priorities) {
        this.p.set_file_priorities2(Priority.array2byte_vector(priorities));
    }

    public void piecePriorities(Priority[] priorities) {
        this.p.set_piece_priorities2(Priority.array2byte_vector(priorities));
    }

    public ArrayList<TcpEndpoint> peers() {
        tcp_endpoint_vector v = this.p.get_peers();
        int size = (int)v.size();
        ArrayList<TcpEndpoint> l = new ArrayList<TcpEndpoint>();
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(new TcpEndpoint(v.get(i2)));
        }
        return l;
    }

    public void peers(List<TcpEndpoint> value) {
        tcp_endpoint_vector v = new tcp_endpoint_vector();
        for (TcpEndpoint endp : value) {
            v.push_back(endp.swig());
        }
        this.p.set_peers(v);
    }

    public ArrayList<TcpEndpoint> bannedPeers() {
        tcp_endpoint_vector v = this.p.get_banned_peers();
        int size = (int)v.size();
        ArrayList<TcpEndpoint> l = new ArrayList<TcpEndpoint>();
        for (int i2 = 0; i2 < size; ++i2) {
            l.add(new TcpEndpoint(v.get(i2)));
        }
        return l;
    }

    public void bannedPeers(List<TcpEndpoint> value) {
        tcp_endpoint_vector v = new tcp_endpoint_vector();
        for (TcpEndpoint endp : value) {
            v.push_back(endp.swig());
        }
        this.p.set_banned_peers(v);
    }

    public static AddTorrentParams createInstance() {
        return new AddTorrentParams(add_torrent_params.create_instance());
    }

    public static AddTorrentParams createInstanceDisabledStorage() {
        return new AddTorrentParams(add_torrent_params.create_instance_disabled_storage());
    }

    public static AddTorrentParams createInstanceZeroStorage() {
        return new AddTorrentParams(add_torrent_params.create_instance_zero_storage());
    }

    public static AddTorrentParams parseMagnetUri(String uri) {
        error_code ec = new error_code();
        add_torrent_params params = add_torrent_params.parse_magnet_uri(uri, ec);
        if (ec.value() != 0) {
            throw new IllegalArgumentException("Invalid magnet uri: " + ec.message());
        }
        return new AddTorrentParams(params);
    }
}

