/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.ThemeMediator;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.SynthTableUI;

public class SkinTableUI
extends SynthTableUI {
    private MouseInputListener mouseListener;
    private Point lastMousePosition;

    public static ComponentUI createUI(JComponent comp) {
        ThemeMediator.testComponentCreationThreadingViolation();
        return new SkinTableUI();
    }

    public int getRowAtMouse() {
        int row = -1;
        if (this.lastMousePosition != null) {
            row = this.table.rowAtPoint(this.lastMousePosition);
        }
        return row;
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new TableMouseInputListener(super.createMouseInputListener());
        }
        return this.mouseListener;
    }

    private void repaintAtPoint(Point p) {
        if (p != null) {
            this.table.repaint(0, p.y - 50, this.table.getWidth(), 100);
        }
    }

    private class TableMouseInputListener
    implements MouseInputListener {
        private final MouseInputListener delegate;

        public TableMouseInputListener(MouseInputListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.delegate.mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.delegate.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.delegate.mouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.delegate.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.delegate.mouseExited(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.delegate.mouseDragged(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p;
            this.delegate.mouseMoved(e);
            SkinTableUI.this.repaintAtPoint(SkinTableUI.this.lastMousePosition);
            SkinTableUI.this.lastMousePosition = p = e.getPoint();
            SkinTableUI.this.repaintAtPoint(p);
        }
    }
}

