/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.AbstractSkinPainter;
import com.frostwire.gui.theme.SkinColors;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Path2D;
import javax.swing.JComponent;

public final class SkinTableHeaderPainter
extends AbstractSkinPainter {
    private final State state;

    public SkinTableHeaderPainter(State state) {
        this.state = state;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        if (this.testValid(0, 0, width - 1, height - 1)) {
            Shape s = this.shapeGenerator.createRectangle(0, 0, width, height);
            g.setPaint(this.getTableHeaderPaint(s));
            g.fill(s);
            this.paintBorder(g, width, height);
        }
    }

    private void paintBorder(Graphics2D g, int width, int height) {
        Path2D.Double path = new Path2D.Double(0);
        path.reset();
        ((Path2D)path).moveTo(0.0, height - 1);
        ((Path2D)path).lineTo(width - 1, height - 1);
        ((Path2D)path).lineTo(width - 1, 0.0);
        g.setPaint(SkinColors.TABLE_HEADER_BORDER_COLOR);
        g.draw(path);
    }

    private Paint getTableHeaderPaint(Shape s) {
        switch (this.state) {
            case Enabled: {
                return this.createVerticalGradient(s, SkinColors.TABLE_HEADER_ENABLED_COLORS);
            }
            case MouseOver: 
            case Pressed: {
                return this.createVerticalGradient(s, SkinColors.TABLE_HEADER_PRESSED_COLORS);
            }
        }
        throw new IllegalArgumentException("Not supported state");
    }

    public static enum State {
        Enabled,
        MouseOver,
        Pressed;

    }
}

