/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.ThemeMediator;
import com.limegroup.gnutella.gui.search.RangeSlider;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthSliderUI;

public class SkinRangeSliderUI
extends SynthSliderUI {
    private RangeSliderAdditionalUI additonalUi;
    private MouseInputAdapter thumbTrackListener;
    private final Rectangle zeroRect = new Rectangle();
    private transient boolean mousePressed;
    private transient boolean mouseOver;

    public SkinRangeSliderUI(JSlider c) {
        super(c);
    }

    public static ComponentUI createUI(JComponent c) {
        ThemeMediator.testComponentCreationThreadingViolation();
        return new SkinRangeSliderUI((JSlider)c);
    }

    @Override
    public void installUI(JComponent c) {
        this.additonalUi = new RangeSliderAdditionalUI(this);
        this.additonalUi.installUI(c);
        this.thumbTrackListener = this.createThumbTrackListener((JSlider)c);
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.additonalUi.uninstallUI(c);
        this.additonalUi = null;
        this.thumbTrackListener = null;
    }

    @Override
    public void scrollByBlock(int direction) {
    }

    @Override
    public void scrollByUnit(int direction) {
    }

    public Rectangle getTrackRect() {
        return this.trackRect;
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return null;
    }

    @Override
    protected ChangeListener createChangeListener(JSlider slider) {
        return this.additonalUi.changeHandler;
    }

    @Override
    protected void installListeners(JSlider slider) {
        slider.addMouseListener(this.thumbTrackListener);
        slider.addMouseMotionListener(this.thumbTrackListener);
        slider.addFocusListener(this.focusListener);
        slider.addComponentListener(this.componentListener);
        slider.addPropertyChangeListener(this.propertyChangeListener);
        slider.getModel().addChangeListener(this.changeListener);
        if (slider instanceof RangeSlider) {
            RangeSlider rangeSlider = (RangeSlider)slider;
            for (int i2 = 0; i2 < rangeSlider.getThumbNum(); ++i2) {
                rangeSlider.getModelAt(i2).addChangeListener(this.changeListener);
            }
        }
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        slider.removeMouseListener(this.thumbTrackListener);
        slider.removeMouseMotionListener(this.thumbTrackListener);
        slider.removeFocusListener(this.focusListener);
        slider.removeComponentListener(this.componentListener);
        slider.removePropertyChangeListener(this.propertyChangeListener);
        slider.getModel().removeChangeListener(this.changeListener);
        if (slider instanceof RangeSlider) {
            RangeSlider rangeSlider = (RangeSlider)slider;
            for (int i2 = 0; i2 < rangeSlider.getThumbNum(); ++i2) {
                rangeSlider.getModelAt(i2).removeChangeListener(this.changeListener);
            }
        }
    }

    @Override
    protected void calculateGeometry() {
        super.calculateGeometry();
        this.additonalUi.calculateThumbsSize();
        this.additonalUi.calculateThumbsLocation();
    }

    @Override
    protected void calculateThumbLocation() {
    }

    @Override
    protected void paint(SynthContext context, Graphics g) {
        this.calculateThumbRect();
        super.paint(context, g);
    }

    @Override
    protected void paintThumb(SynthContext context, Graphics g, Rectangle thumbBounds) {
        this.paintThumbs(context, g);
    }

    private void paintThumbs(SynthContext context, Graphics g) {
        Rectangle clip = g.getClipBounds();
        int thumbNum = this.additonalUi.getThumbNum();
        Rectangle[] thumbRects = this.additonalUi.getThumbRects();
        for (int i2 = thumbNum - 1; 0 <= i2; --i2) {
            if (!clip.intersects(thumbRects[i2])) continue;
            this.thumbRect = thumbRects[i2];
            super.paintThumb(this.getThumbContext(context), g, this.thumbRect);
        }
    }

    private void calculateThumbRect() {
        int thumbNum = this.additonalUi.getThumbNum();
        Rectangle[] thumbRects = this.additonalUi.getThumbRects();
        this.thumbRect = this.zeroRect;
        for (int i2 = thumbNum - 1; 0 <= i2; --i2) {
            Rectangle rect = thumbRects[i2];
            SwingUtilities.computeUnion(rect.x, rect.y, rect.width, rect.height, this.thumbRect);
        }
    }

    private MouseInputAdapter createThumbTrackListener(JSlider slider) {
        return this.additonalUi.trackListener;
    }

    private SynthContext getThumbContext(SynthContext ctx) {
        SynthContext context = ctx;
        int state = ctx.getComponentState();
        if (this.mousePressed) {
            state |= 4;
        }
        if (this.mouseOver) {
            state |= 2;
        }
        if (state != ctx.getComponentState()) {
            context = new SynthContext(ctx.getComponent(), ctx.getRegion(), ctx.getStyle(), state);
        }
        return context;
    }

    private void setMousePressed(boolean pressed) {
        if (this.mousePressed != pressed) {
            this.mousePressed = pressed;
            this.slider.repaint();
        }
    }

    private void setMouseOver(boolean pressed) {
        if (this.mouseOver != pressed) {
            this.mouseOver = pressed;
            this.slider.repaint();
        }
    }

    private static class RangeSliderAdditionalUI {
        private static final Rectangle unionRect = new Rectangle();
        private RangeSlider mSlider;
        private final SkinRangeSliderUI ui;
        private Rectangle[] thumbRects;
        private int thumbNum;
        private transient boolean isDragging;
        private ChangeHandler changeHandler;
        private TrackListener trackListener;

        public RangeSliderAdditionalUI(SkinRangeSliderUI ui) {
            this.ui = ui;
        }

        public void installUI(JComponent c) {
            this.mSlider = (RangeSlider)c;
            this.thumbNum = this.mSlider.getThumbNum();
            this.thumbRects = new Rectangle[this.thumbNum];
            for (int i2 = 0; i2 < this.thumbNum; ++i2) {
                this.thumbRects[i2] = new Rectangle();
            }
            this.isDragging = false;
            this.trackListener = new TrackListener(this.mSlider);
            this.changeHandler = new ChangeHandler();
        }

        public void uninstallUI(JComponent c) {
            this.thumbRects = null;
            this.trackListener = null;
            this.changeHandler = null;
        }

        public int getThumbNum() {
            return this.thumbNum;
        }

        public Rectangle[] getThumbRects() {
            return this.thumbRects;
        }

        public void setThumbLocationAt(int x, int y, int index) {
            Rectangle rect = this.thumbRects[index];
            unionRect.setBounds(rect);
            rect.setLocation(x, y);
            SwingUtilities.computeUnion(rect.x, rect.y, rect.width, rect.height, unionRect);
            this.mSlider.repaint(RangeSliderAdditionalUI.unionRect.x, RangeSliderAdditionalUI.unionRect.y, RangeSliderAdditionalUI.unionRect.width, RangeSliderAdditionalUI.unionRect.height);
        }

        public Rectangle getTrackRect() {
            return this.ui.getTrackRect();
        }

        protected void calculateThumbsSize() {
            Dimension size = this.ui.getThumbSize();
            for (int i2 = 0; i2 < this.thumbNum; ++i2) {
                this.thumbRects[i2].setSize(size.width, size.height);
            }
        }

        protected void calculateThumbsLocation() {
            for (int i2 = 0; i2 < this.thumbNum; ++i2) {
                if (this.mSlider.getSnapToTicks()) {
                    int tickSpacing = this.mSlider.getMinorTickSpacing();
                    if (tickSpacing == 0) {
                        tickSpacing = this.mSlider.getMajorTickSpacing();
                    }
                    if (tickSpacing != 0) {
                        int sliderValue;
                        int snappedValue = sliderValue = this.mSlider.getValueAt(i2);
                        int min = this.mSlider.getMinimum();
                        if ((sliderValue - min) % tickSpacing != 0) {
                            float temp = (float)(sliderValue - min) / (float)tickSpacing;
                            int whichTick = Math.round(temp);
                            snappedValue = min + whichTick * tickSpacing;
                            this.mSlider.setValueAt(snappedValue, i2);
                        }
                    }
                }
                Rectangle trackRect = this.getTrackRect();
                if (this.mSlider.getOrientation() == 0) {
                    int value = this.mSlider.getValueAt(i2);
                    int valuePosition = this.ui.xPositionForValue(value);
                    this.thumbRects[i2].x = valuePosition - this.thumbRects[i2].width / 2;
                    this.thumbRects[i2].y = trackRect.y;
                    continue;
                }
                int valuePosition = this.ui.yPositionForValue(this.mSlider.getValueAt(i2));
                this.thumbRects[i2].x = trackRect.x;
                this.thumbRects[i2].y = valuePosition - this.thumbRects[i2].height / 2;
            }
        }

        public class TrackListener
        extends MouseInputAdapter {
            protected transient int offset;
            protected transient int currentMouseX;
            protected transient int currentMouseY;
            protected Rectangle adjustingThumbRect = null;
            protected int adjustingThumbIndex;
            protected final RangeSlider slider;
            protected Rectangle trackRect;

            TrackListener(RangeSlider slider) {
                this.slider = slider;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!this.slider.isEnabled()) {
                    return;
                }
                RangeSliderAdditionalUI.this.ui.setMousePressed(true);
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                this.slider.requestFocus();
                for (int i2 = 0; i2 < RangeSliderAdditionalUI.this.thumbNum; ++i2) {
                    Rectangle rect = RangeSliderAdditionalUI.this.thumbRects[i2];
                    if (!rect.contains(this.currentMouseX, this.currentMouseY)) continue;
                    switch (this.slider.getOrientation()) {
                        case 1: {
                            this.offset = this.currentMouseY - rect.y;
                            break;
                        }
                        case 0: {
                            this.offset = this.currentMouseX - rect.x;
                        }
                    }
                    RangeSliderAdditionalUI.this.isDragging = true;
                    this.slider.setValueIsAdjusting(true);
                    this.adjustingThumbRect = rect;
                    this.adjustingThumbIndex = i2;
                    if (this.slider.getOrientation() == 0 && this.adjustingThumbIndex == 0 && RangeSliderAdditionalUI.this.thumbRects[1].equals(rect)) {
                        int halfThumbWidth = rect.width / 2;
                        int thumbLeft = RangeSliderAdditionalUI.this.ui.xPositionForValue(RangeSliderAdditionalUI.this.mSlider.getValueAt(1) - 1) - halfThumbWidth;
                        if (thumbLeft <= 1) {
                            this.adjustingThumbIndex = 1;
                        }
                    }
                    return;
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!(this.slider.isEnabled() && RangeSliderAdditionalUI.this.isDragging && this.slider.getValueIsAdjusting() && this.adjustingThumbRect != null)) {
                    return;
                }
                int thumbMiddle = 0;
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                Rectangle rect = RangeSliderAdditionalUI.this.thumbRects[this.adjustingThumbIndex];
                this.trackRect = RangeSliderAdditionalUI.this.getTrackRect();
                switch (this.slider.getOrientation()) {
                    case 1: {
                        int halfThumbHeight = rect.height / 2;
                        int thumbTop = e.getY() - this.offset;
                        int trackTop = this.trackRect.y;
                        int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
                        thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                        thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                        RangeSliderAdditionalUI.this.setThumbLocationAt(rect.x, thumbTop, this.adjustingThumbIndex);
                        thumbMiddle = thumbTop + halfThumbHeight;
                        RangeSliderAdditionalUI.this.mSlider.setValueAt(RangeSliderAdditionalUI.this.ui.valueForYPosition(thumbMiddle), this.adjustingThumbIndex);
                        break;
                    }
                    case 0: {
                        int halfThumbWidth = rect.width / 2;
                        int thumbLeft = e.getX() - this.offset;
                        int trackLeft = this.trackRect.x;
                        int trackRight = this.trackRect.x + (this.trackRect.width - 1);
                        thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                        thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                        if (this.adjustingThumbIndex == 0) {
                            thumbLeft = Math.min(thumbLeft, RangeSliderAdditionalUI.this.ui.xPositionForValue(RangeSliderAdditionalUI.this.mSlider.getValueAt(1) - 1) - halfThumbWidth);
                        }
                        if (this.adjustingThumbIndex == 1) {
                            thumbLeft = Math.max(RangeSliderAdditionalUI.this.ui.xPositionForValue(RangeSliderAdditionalUI.this.mSlider.getValueAt(0) + 1) - halfThumbWidth, thumbLeft);
                        }
                        RangeSliderAdditionalUI.this.setThumbLocationAt(thumbLeft, rect.y, this.adjustingThumbIndex);
                        thumbMiddle = thumbLeft + halfThumbWidth;
                        RangeSliderAdditionalUI.this.mSlider.setValueAt(RangeSliderAdditionalUI.this.ui.valueForXPosition(thumbMiddle), this.adjustingThumbIndex);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!this.slider.isEnabled()) {
                    return;
                }
                this.offset = 0;
                RangeSliderAdditionalUI.this.isDragging = false;
                RangeSliderAdditionalUI.this.mSlider.setValueIsAdjusting(false);
                RangeSliderAdditionalUI.this.ui.setMousePressed(false);
                RangeSliderAdditionalUI.this.mSlider.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RangeSliderAdditionalUI.this.ui.setMouseOver(false);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                RangeSliderAdditionalUI.this.ui.setMouseOver(true);
            }
        }

        public class ChangeHandler
        implements ChangeListener {
            @Override
            public void stateChanged(ChangeEvent e) {
                if (!RangeSliderAdditionalUI.this.isDragging) {
                    RangeSliderAdditionalUI.this.calculateThumbsLocation();
                    RangeSliderAdditionalUI.this.mSlider.repaint();
                }
            }
        }
    }
}

