/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.AbstractSkinPainter;
import com.frostwire.gui.theme.SkinColors;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SkinProgressBarPainter
extends AbstractSkinPainter {
    private final State state;
    private final int padding;

    public SkinProgressBarPainter(State state, int padding) {
        this.state = state;
        this.padding = padding;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case Enabled: 
            case Disabled: {
                this.paintBar(g, c, width, height);
                break;
            }
            case EnabledIndeterminate: 
            case DisabledIndeterminate: {
                this.paintIndeterminateBar(g, width, height);
            }
        }
    }

    private void paintBar(Graphics2D g, JComponent c, int width, int height) {
        int d = this.padding - 1;
        int d2 = 2 * d;
        if (this.testValid(d, d, width -= d2, height = height - d2 - 1)) {
            Shape s = this.shapeGenerator.createRectangle(d, d, width, height);
            g.setPaint(this.getProgressBarPaint(s));
            g.fill(s);
            g.setPaint(this.getProgressBarBorderPaint());
            g.draw(s);
        }
    }

    private void paintIndeterminateBar(Graphics2D g, int width, int height) {
        if (this.testValid(0, 0, width, height)) {
            Shape s = this.shapeGenerator.createProgressBarIndeterminatePattern(0, 0, width, height);
            g.setPaint(this.getProgressBarIndeterminatePaint(s));
            g.fill(s);
        }
    }

    private Paint getProgressBarPaint(Shape s) {
        Color[] colors = this.state == State.Enabled ? SkinColors.PROGRESS_BAR_ENABLED_GRADIENT_COLORS : SkinColors.PROGRESS_BAR_DISABLED_GRADIENT_COLORS;
        return this.createVerticalGradient(s, colors);
    }

    private Paint getProgressBarBorderPaint() {
        return this.state == State.Enabled ? SkinColors.PROGRESS_BAR_ENABLED_BORDER_COLOR : SkinColors.PROGRESS_BAR_DISABLED_BORDER_COLOR;
    }

    private Paint getProgressBarIndeterminatePaint(Shape s) {
        Color[] colors = this.state == State.EnabledIndeterminate ? SkinColors.PROGRESS_BAR_ENABLED_INDERTERMINATE_GRADIENT_COLORS : SkinColors.PROGRESS_BAR_DISABLED_INDERTERMINATE_GRADIENT_COLORS;
        return this.createVerticalGradient(s, colors);
    }

    public static enum State {
        Enabled,
        Disabled,
        EnabledIndeterminate,
        DisabledIndeterminate;

    }
}

